/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.protocols.sftp.SftpUrlConnection;
import org.opennms.protocols.sftp.SftpUrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.collector.XmlCollectorException;
import org.opennms.protocols.xml.collector.XmlMultiInstanceCollectionResource;
import org.opennms.protocols.xml.collector.XmlSingleInstanceCollectionResource;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCollector
implements ServiceCollector {
    private XmlDataCollectionConfigDao m_xmlCollectionDao;
    private HashMap<String, XmlCollectionAttributeType> m_attribTypeList = new HashMap();

    public XmlDataCollectionConfigDao getXmlCollectionDao() {
        return this.m_xmlCollectionDao;
    }

    public void setXmlCollectionDao(XmlDataCollectionConfigDao xmlCollectionDao) {
        this.m_xmlCollectionDao = xmlCollectionDao;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void loadAttributes(XmlDataCollection collection) {
        for (XmlSource source : collection.getXmlSources()) {
            for (XmlGroup group : source.getXmlGroups()) {
                AttributeGroupType attribGroupType = new AttributeGroupType(group.getName(), group.getIfType());
                for (XmlObject object : group.getXmlObjects()) {
                    XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(object, attribGroupType);
                    this.m_attribTypeList.put(object.getName(), attribType);
                }
            }
        }
    }

    public void initialize(Map<String, String> parameters) {
        this.log().debug("initialize: Initializing XML Collector.");
        this.initialize();
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        this.log().debug("initialize: Initializing XML collection for agent: " + agent);
        this.initialize();
    }

    private void initialize() {
        if (this.m_xmlCollectionDao == null) {
            this.m_xmlCollectionDao = (XmlDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"xmlDataCollectionConfigDao", XmlDataCollectionConfigDao.class);
        }
        this.log().debug("initializeRrdRepository: Initializing RRD repo from XmlCollector...");
        File f = new File(this.m_xmlCollectionDao.getConfig().getRrdRepository());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_xmlCollectionDao.getConfig().getRrdRepository());
        }
    }

    public void release() {
    }

    public void release(CollectionAgent agent) {
    }

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        XmlCollectionSet collectionSet = new XmlCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(0);
        if (parameters == null) {
            this.log().error("Null parameters is now allowed in XML Collector!!");
            return collectionSet;
        }
        try {
            String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(parameters, (String)"xml-collection", null);
            }
            this.log().debug("collect: collecting XML data using collection " + collectionName);
            XmlDataCollection collection = this.m_xmlCollectionDao.getDataCollectionByName(collectionName);
            this.loadAttributes(collection);
            for (XmlSource source : collection.getXmlSources()) {
                Document doc = this.getXmlDocument(agent, source);
                XPath xpath = XPathFactory.newInstance().newXPath();
                for (XmlGroup group : source.getXmlGroups()) {
                    this.log().debug("collect: getting resources for XML group " + group.getName() + " using XPATH " + group.getResourceXpath());
                    NodeList resourceList = (NodeList)xpath.evaluate(group.getResourceXpath(), doc, XPathConstants.NODESET);
                    for (int j = 0; j < resourceList.getLength(); ++j) {
                        Node resource = resourceList.item(j);
                        Node resourceName = (Node)xpath.evaluate(group.getKeyXpath(), resource, XPathConstants.NODE);
                        this.log().debug("collect: processing XML resource " + resourceName);
                        XmlCollectionResource collectionResource = this.getCollectionResource(agent, resourceName.getNodeValue(), group.getResourceType());
                        for (XmlObject object : group.getXmlObjects()) {
                            String value = (String)xpath.evaluate(object.getXpath(), resource, XPathConstants.STRING);
                            collectionResource.setAttributeValue(this.m_attribTypeList.get(object.getName()), value);
                        }
                        collectionSet.getCollectionResources().add(collectionResource);
                    }
                }
            }
            collectionSet.setStatus(1);
            return collectionSet;
        }
        catch (Exception e) {
            collectionSet.setStatus(2);
            throw new CollectionException("Can't collect XML data.", (Throwable)e);
        }
    }

    private XmlCollectionResource getCollectionResource(CollectionAgent agent, String instance, String resourceType) {
        XmlCollectionResource resource = null;
        resource = resourceType.toLowerCase().equals("node") ? new XmlSingleInstanceCollectionResource(agent) : new XmlMultiInstanceCollectionResource(agent, instance, resourceType);
        return resource;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_xmlCollectionDao.getConfig().buildRrdRepository(collectionName);
    }

    public Document getXmlDocument(CollectionAgent agent, XmlSource source) {
        String urlStr = source.getUrl().replace("{ipaddr}", agent.getHostAddress());
        try {
            URL url = SftpUrlFactory.getUrl(urlStr);
            URLConnection c = url.openConnection();
            c.connect();
            InputStream is = c.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            if (c instanceof SftpUrlConnection) {
                ((SftpUrlConnection)c).disconnect();
            }
            return doc;
        }
        catch (Exception e) {
            throw new XmlCollectorException("Can't retrieve data from " + urlStr);
        }
    }
}

