/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.opennms.core.utils.ThreadCategory;

public class SftpUrlConnection
extends URLConnection {
    protected URL m_url;
    protected Session m_session;
    protected ChannelSftp m_channel;

    protected SftpUrlConnection(URL url) {
        super(url);
        this.m_url = url;
    }

    @Override
    public void connect() throws IOException {
        String[] userInfo = this.m_url.getUserInfo().split(":");
        JSch jsch = new JSch();
        try {
            int port = this.m_url.getPort() > 0 ? this.m_url.getPort() : this.m_url.getDefaultPort();
            this.m_session = jsch.getSession(userInfo[0], this.m_url.getHost(), port);
            this.m_session.setPassword(userInfo[1]);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.m_session.setConfig(config);
            this.m_session.connect();
            this.m_channel = (ChannelSftp)this.m_session.openChannel("sftp");
            this.m_channel.connect();
        }
        catch (JSchException e) {
            throw new IOException("Can't connect using " + this.m_url + " because " + e.getMessage());
        }
    }

    public void disconnect() throws IOException {
        this.m_channel.disconnect();
        this.m_session.disconnect();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return this.m_channel.get(this.getPath());
        }
        catch (SftpException e) {
            throw new IOException("Can't retrieve " + this.m_url.getPath() + " from " + this.m_url.getHost() + " because " + e.getMessage());
        }
    }

    protected String getPath() {
        return this.m_url.getPath();
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

