/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.sftp;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.LogUtils;
import org.opennms.protocols.sftp.SftpUrlConnection;

public class Sftp3gppUrlConnection
extends SftpUrlConnection {
    protected Sftp3gppUrlConnection(URL url) {
        super(url);
    }

    @Override
    protected String getPath() {
        String path = this.m_url.getPath();
        if (path.contains("___CURRENT_3GPP_A_FORMAT")) {
            Map<String, String> properties = this.getProperties(this.url);
            this.log().info("Processing 3GPP NE URL on " + path);
            long step = Long.parseLong(properties.get("step")) * 1000L;
            String tz = properties.get("tz-offset");
            long timestamp = System.currentTimeMillis() - System.currentTimeMillis() % step;
            SimpleDateFormat datef = new SimpleDateFormat("yyyyMMdd");
            datef.setTimeZone(TimeZone.getTimeZone(tz));
            SimpleDateFormat timef = new SimpleDateFormat("HHmmZ");
            timef.setTimeZone(TimeZone.getTimeZone(tz));
            StringBuffer sb = new StringBuffer("A");
            sb.append(datef.format(new Date(timestamp)));
            sb.append(".");
            sb.append(timef.format(new Date(timestamp - step)));
            sb.append("-");
            sb.append(timef.format(new Date(timestamp)));
            sb.append("_");
            sb.append(properties.get("neid"));
            sb.append(".xml");
            try {
                RE re = new RE("___CURRENT_3GPP_A_FORMAT");
                path = re.subst(path, sb.toString());
            }
            catch (RESyntaxException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred applying path '%s'", (Object[])new Object[]{path});
            }
        }
        return path;
    }

    private Map<String, String> getProperties(URL url) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (url.getQuery() != null) {
            for (String pair : url.getQuery().split("&")) {
                String[] data = pair.split("=");
                properties.put(data[0].toLowerCase(), data[1]);
            }
        }
        return properties;
    }
}

