/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlResourceType;

public class XmlMultiInstanceCollectionResource
extends XmlCollectionResource {
    private String m_instance;
    private String m_resourceLabel;
    private XmlResourceType m_resourceType;

    public XmlMultiInstanceCollectionResource(CollectionAgent agent, String instance, XmlResourceType type) {
        super(agent);
        this.m_resourceType = type;
        this.m_instance = instance;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return this.m_resourceType.getPersistenceSelectorStrategy().shouldPersist((CollectionResource)this);
    }

    public File getResourceDir(RrdRepository repository) {
        String resourcePath = this.m_resourceType.getStorageStrategy().getRelativePathForAttribute(this.getParent(), this.getLabel(), null);
        File resourceDir = new File(repository.getRrdBaseDir(), resourcePath);
        if (this.log().isDebugEnabled()) {
            this.log().debug("getResourceDir: " + resourceDir);
        }
        return resourceDir;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_resourceType.getName();
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    public String toString() {
        return "node[" + this.m_agent.getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getLabel() + "]";
    }

    public String getLabel() {
        if (this.m_resourceLabel == null) {
            this.m_resourceLabel = this.m_resourceType.getStorageStrategy().getResourceNameFromIndex((CollectionResource)this);
        }
        return this.m_resourceLabel;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

