/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlRrd;

@XmlRootElement(name="xml-datacollection-config")
public class XmlDataCollectionConfig
implements Serializable,
Comparable<XmlDataCollectionConfig> {
    private static final long serialVersionUID = -7884808717236892997L;
    public static final String XML_DATACOLLECTION_CONFIG_FILE = "xml-datacollection-config.xml";
    private static final XmlDataCollection[] OF_DATA_COLLECTIONS = new XmlDataCollection[0];
    @XmlElement(name="xml-collection")
    private List<XmlDataCollection> m_xmlDataCollections = new ArrayList<XmlDataCollection>();
    @XmlAttribute(name="rrdRepository")
    private String m_rrdRepository;

    @XmlTransient
    public List<XmlDataCollection> getXmlDataCollections() {
        return this.m_xmlDataCollections;
    }

    public void setXmlDataCollections(List<XmlDataCollection> xmlDataCollections) {
        this.m_xmlDataCollections = xmlDataCollections;
    }

    @XmlTransient
    public String getRrdRepository() {
        return this.m_rrdRepository;
    }

    public void setRrdRepository(String rrdRepository) {
        this.m_rrdRepository = rrdRepository;
    }

    public void addDataCollection(XmlDataCollection dataCollection) {
        this.m_xmlDataCollections.add(dataCollection);
    }

    public void removeDataCollection(XmlDataCollection dataCollection) {
        this.m_xmlDataCollections.remove(dataCollection);
    }

    public void removeDataCollectionByName(String name) {
        for (XmlDataCollection dataCollection : this.m_xmlDataCollections) {
            if (!dataCollection.getName().equals(name)) continue;
            this.m_xmlDataCollections.remove(dataCollection);
            return;
        }
    }

    public XmlDataCollection getDataCollectionByName(String name) {
        for (XmlDataCollection dataCol : this.m_xmlDataCollections) {
            if (!dataCol.getName().equals(name)) continue;
            return dataCol;
        }
        return null;
    }

    public RrdRepository buildRrdRepository(String collectionName) {
        XmlDataCollection collection = this.getDataCollectionByName(collectionName);
        if (collection == null) {
            return null;
        }
        XmlRrd rrd = collection.getXmlRrd();
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdRepository()));
        repo.setRraList(rrd.getXmlRras());
        repo.setStep(rrd.getStep().intValue());
        repo.setHeartBeat(2 * rrd.getStep());
        return repo;
    }

    @Override
    public int compareTo(XmlDataCollectionConfig obj) {
        return new CompareToBuilder().append((Object)this.getRrdRepository(), (Object)obj.getRrdRepository()).append((Object[])this.getXmlDataCollections().toArray(OF_DATA_COLLECTIONS), (Object[])obj.getXmlDataCollections().toArray(OF_DATA_COLLECTIONS)).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlDataCollectionConfig) {
            XmlDataCollectionConfig other = (XmlDataCollectionConfig)obj;
            return new EqualsBuilder().append((Object)this.getRrdRepository(), (Object)other.getRrdRepository()).append((Object[])this.getXmlDataCollections().toArray(OF_DATA_COLLECTIONS), (Object[])other.getXmlDataCollections().toArray(OF_DATA_COLLECTIONS)).isEquals();
        }
        return false;
    }
}

