/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.collector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.SingleResourceCollectionSet;
import org.opennms.netmgt.config.nsclient.Attrib;
import org.opennms.netmgt.config.nsclient.NsclientCollection;
import org.opennms.netmgt.config.nsclient.Wpm;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.nsclient.NSClientAgentConfig;
import org.opennms.protocols.nsclient.NsclientCheckParams;
import org.opennms.protocols.nsclient.NsclientException;
import org.opennms.protocols.nsclient.NsclientManager;
import org.opennms.protocols.nsclient.NsclientPacket;
import org.opennms.protocols.nsclient.config.NSClientDataCollectionConfigFactory;
import org.opennms.protocols.nsclient.config.NSClientPeerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSClientCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NSClientCollector.class);
    private final Map<Integer, NSClientAgentState> m_scheduledNodes = new HashMap<Integer, NSClientAgentState>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) {
        int status = 2;
        ServiceParameters serviceParams = new ServiceParameters(parameters);
        String collectionName = serviceParams.getCollectionName();
        NsclientCollection collection = NSClientDataCollectionConfigFactory.getInstance().getNSClientCollection(collectionName);
        NSClientAgentState agentState = this.m_scheduledNodes.get(agent.getNodeId());
        NSClientCollectionResource collectionResource = new NSClientCollectionResource(agent);
        SingleResourceCollectionSet collectionSet = new SingleResourceCollectionSet((CollectionResource)collectionResource, new Date());
        for (Wpm wpm : collection.getWpms().getWpm()) {
            NsclientManager manager;
            AttributeGroupType attribGroupType = new AttributeGroupType(wpm.getName(), "all");
            if (agentState.shouldCheckAvailability(wpm.getName(), wpm.getRecheckInterval())) {
                LOG.debug("Checking availability of group {}", (Object)wpm.getName());
                manager = null;
                try {
                    manager = agentState.getManager();
                    manager.init();
                    NsclientCheckParams params = new NsclientCheckParams(wpm.getKeyvalue());
                    NsclientPacket result = manager.processCheckCommand("8", params);
                    manager.close();
                    boolean isAvailable = result.getResultCode() == 0;
                    agentState.setGroupIsAvailable(wpm.getName(), isAvailable);
                    LOG.debug("Group {} is {}available ", (Object)wpm.getName(), (Object)(isAvailable ? "" : "not"));
                }
                catch (NsclientException e) {
                    LOG.error("Error checking group ({}) availability", (Object)wpm.getName(), (Object)e);
                    agentState.setGroupIsAvailable(wpm.getName(), false);
                }
                finally {
                    if (manager != null) {
                        manager.close();
                    }
                }
            }
            if (!agentState.groupIsAvailable(wpm.getName())) continue;
            try {
                manager = agentState.getManager();
                manager.init();
                for (Attrib attrib : wpm.getAttrib()) {
                    NsclientPacket result = null;
                    try {
                        NsclientCheckParams params = new NsclientCheckParams(attrib.getName());
                        result = manager.processCheckCommand("8", params);
                    }
                    catch (NsclientException e) {
                        LOG.info("unable to collect params for attribute '{}'", (Object)attrib.getName(), (Object)e);
                    }
                    if (result == null) continue;
                    if (result.getResultCode() != 0) {
                        LOG.info("not writing parameters for attribute '{}', state is not 'OK'", (Object)attrib.getName());
                        continue;
                    }
                    NSClientCollectionAttributeType attribType = new NSClientCollectionAttributeType(attrib, attribGroupType);
                    collectionResource.setAttributeValue((CollectionAttributeType)attribType, result.getResponse());
                    status = 1;
                }
                manager.close();
            }
            catch (NsclientException e) {
                LOG.error("Error collecting data", (Throwable)e);
            }
        }
        collectionSet.setStatus(status);
        return collectionSet;
    }

    public void initialize(Map<String, String> parameters) {
        LOG.debug("initialize: Initializing NSClientCollector.");
        this.m_scheduledNodes.clear();
        NSClientCollector.initNSClientPeerFactory();
        NSClientCollector.initNSClientCollectionConfig();
        NSClientCollector.initializeRrdRepository();
    }

    private static void initNSClientPeerFactory() {
        LOG.debug("initialize: Initializing NSClientPeerFactory");
        try {
            NSClientPeerFactory.init();
        }
        catch (MarshalException e) {
            LOG.error("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LOG.error("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void initNSClientCollectionConfig() {
        LOG.debug("initialize: Initializing collector: {}", NSClientCollector.class);
        try {
            NSClientDataCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            LOG.error("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LOG.error("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            LOG.error("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void initializeRrdRepository() {
        LOG.debug("initializeRrdRepository: Initializing RRD repo from NSClientCollector...");
        NSClientCollector.initializeRrdDirs();
    }

    private static void initializeRrdDirs() {
        File f = new File(NSClientDataCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + NSClientDataCollectionConfigFactory.getInstance().getRrdPath());
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        LOG.debug("initialize: Initializing NSClient collection for agent: {}", (Object)agent);
        Integer scheduledNodeKey = agent.getNodeId();
        NSClientAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            LOG.info("initialize: Not scheduling interface for NSClient collection: {}", (Object)nodeState.getAddress());
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(" for address: ");
            sb.append(nodeState.getAddress());
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            LOG.debug(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        nodeState = new NSClientAgentState((InetAddress)agent.getAddress(), parameters);
        LOG.info("initialize: Scheduling interface for collection: {}", (Object)nodeState.getAddress());
        this.m_scheduledNodes.put(scheduledNodeKey, nodeState);
    }

    public void release() {
        this.m_scheduledNodes.clear();
    }

    public void release(CollectionAgent agent) {
        Integer scheduledNodeKey = agent.getNodeId();
        NSClientAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.m_scheduledNodes.remove(scheduledNodeKey);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return NSClientDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    private static class NSClientGroupState {
        private boolean available = false;
        private Date lastChecked;

        public NSClientGroupState(boolean isAvailable) {
            this(isAvailable, new Date());
        }

        public NSClientGroupState(boolean isAvailable, Date lastChecked) {
            this.available = isAvailable;
            this.lastChecked = lastChecked;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public void setAvailable(boolean available) {
            this.available = available;
        }

        public Date getLastChecked() {
            return this.lastChecked;
        }

        public void setLastChecked(Date lastChecked) {
            this.lastChecked = lastChecked;
        }
    }

    private static class NSClientAgentState {
        private final NsclientManager m_manager;
        private final NSClientAgentConfig m_agentConfig;
        private final String m_address;
        private final Map<String, NSClientGroupState> m_groupStates = new HashMap<String, NSClientGroupState>();

        public NSClientAgentState(InetAddress address, Map<String, Object> parameters) {
            this.m_address = InetAddressUtils.str((InetAddress)address);
            this.m_agentConfig = NSClientPeerFactory.getInstance().getAgentConfig(address);
            this.m_manager = new NsclientManager(this.m_address);
            this.m_manager.setPassword(this.m_agentConfig.getPassword());
            this.m_manager.setTimeout(this.m_agentConfig.getTimeout());
            this.m_manager.setPortNumber(this.m_agentConfig.getPort());
        }

        public String getAddress() {
            return this.m_address;
        }

        public NsclientManager getManager() {
            return this.m_manager;
        }

        public boolean groupIsAvailable(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return false;
            }
            return groupState.isAvailable();
        }

        public void setGroupIsAvailable(String groupName, boolean available) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                groupState = new NSClientGroupState(available);
            }
            groupState.setAvailable(available);
            this.m_groupStates.put(groupName, groupState);
        }

        public boolean shouldCheckAvailability(String groupName, int recheckInterval) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return true;
            }
            Date lastchecked = groupState.getLastChecked();
            Date now = new Date();
            return now.getTime() - lastchecked.getTime() > (long)recheckInterval;
        }

        public void didCheckGroupAvailability(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                LOG.warn("didCheckGroupAvailability called on a group without state - this is odd");
                return;
            }
            groupState.setLastChecked(new Date());
        }
    }

    private static class NSClientCollectionResource
    extends AbstractCollectionResource {
        public NSClientCollectionResource(CollectionAgent agent) {
            super(agent);
        }

        public void setAttributeValue(CollectionAttributeType type, String value) {
            NSClientCollectionAttribute attr = new NSClientCollectionAttribute(this, type, value);
            this.addAttribute((CollectionAttribute)attr);
        }

        public String getResourceTypeName() {
            return "node";
        }

        public String getInstance() {
            return null;
        }
    }

    private static class NSClientCollectionAttribute
    extends AbstractCollectionAttribute {
        private final String m_value;

        public NSClientCollectionAttribute(NSClientCollectionResource resource, CollectionAttributeType attribType, String value) {
            super(attribType, (CollectionResource)resource);
            this.m_value = value;
        }

        public String getNumericValue() {
            return this.m_value;
        }

        public String getStringValue() {
            return this.m_value;
        }

        public String toString() {
            return "NSClientCollectionAttribute " + this.getName() + "=" + this.m_value;
        }

        public String getMetricIdentifier() {
            return "Not supported yet._NSC_" + this.getName();
        }
    }

    private static class NSClientCollectionAttributeType
    extends AbstractCollectionAttributeType {
        private final Attrib m_attribute;

        public NSClientCollectionAttributeType(Attrib attribute, AttributeGroupType groupType) {
            super(groupType);
            this.m_attribute = attribute;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            persister.persistNumericAttribute(attribute);
        }

        public String getName() {
            return this.m_attribute.getAlias();
        }

        public String getType() {
            return this.m_attribute.getType();
        }
    }
}

