/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.nsclient.Definition;
import org.opennms.netmgt.config.nsclient.NsclientConfig;
import org.opennms.netmgt.config.nsclient.Range;
import org.opennms.protocols.nsclient.NSClientAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class NSClientPeerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NSClientPeerFactory.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private static NSClientPeerFactory m_singleton = null;
    private NsclientConfig m_config;
    private static boolean m_loaded = false;

    private NSClientPeerFactory(String configFile) throws IOException, MarshalException, ValidationException {
        this.m_config = (NsclientConfig)CastorUtils.unmarshal(NsclientConfig.class, (Resource)new FileSystemResource(configFile));
    }

    public NSClientPeerFactory(InputStream stream) throws IOException, MarshalException, ValidationException {
        this.m_config = (NsclientConfig)CastorUtils.unmarshal(NsclientConfig.class, (InputStream)stream);
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        m_singleton = new NSClientPeerFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        NSClientPeerFactory.init();
    }

    NsclientConfig getConfig() {
        return this.m_config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCurrent() throws Exception {
        this.getWriteLock().lock();
        try {
            this.optimize();
            StringWriter stringWriter = new StringWriter();
            Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
            if (stringWriter.toString() != null) {
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_CONFIG_FILE_NAME)), "UTF-8");
                fileWriter.write(stringWriter.toString());
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
            NSClientPeerFactory.reload();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public static synchronized NSClientPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The NSClientPeerFactory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(NSClientPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSClientAgentConfig getAgentConfig(InetAddress agentInetAddress) {
        this.getReadLock().lock();
        try {
            if (this.m_config == null) {
                NSClientAgentConfig nSClientAgentConfig = new NSClientAgentConfig(agentInetAddress);
                return nSClientAgentConfig;
            }
            NSClientAgentConfig agentConfig = new NSClientAgentConfig(agentInetAddress);
            this.setNSClientAgentConfig(agentConfig, new Definition());
            block4: for (Definition def : this.m_config.getDefinitionCollection()) {
                for (String saddr : def.getSpecificCollection()) {
                    InetAddress addr = InetAddressUtils.addr((String)saddr);
                    if (!addr.equals(agentConfig.getAddress())) continue;
                    this.setNSClientAgentConfig(agentConfig, def);
                    break block4;
                }
                for (Range rng : def.getRangeCollection()) {
                    if (!InetAddressUtils.isInetAddressInRange((String)InetAddressUtils.str((InetAddress)agentConfig.getAddress()), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                    this.setNSClientAgentConfig(agentConfig, def);
                    break block4;
                }
                for (String ipMatch : def.getIpMatchCollection()) {
                    if (!IPLike.matches((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)ipMatch)) continue;
                    this.setNSClientAgentConfig(agentConfig, def);
                    break block4;
                }
            }
            if (agentConfig == null) {
                this.setNSClientAgentConfig(agentConfig, new Definition());
            }
            NSClientAgentConfig nSClientAgentConfig = agentConfig;
            return nSClientAgentConfig;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void optimize() throws UnknownHostException {
        this.getWriteLock().lock();
        try {
            Iterator<Definition> definitionsIterator = this.m_config.getDefinitionCollection().iterator();
            while (definitionsIterator.hasNext()) {
                Definition definition = definitionsIterator.next();
                if (definition.getSpecificCount() != 0 || definition.getRangeCount() != 0) continue;
                LOG.debug("optimize: Removing empty definition element");
                definitionsIterator.remove();
            }
            for (Definition definition : this.m_config.getDefinitionCollection()) {
                Iterator<Range> rangesIterator = definition.getRangeCollection().iterator();
                while (rangesIterator.hasNext()) {
                    Range range = rangesIterator.next();
                    if (!range.getBegin().equals(range.getEnd())) continue;
                    definition.addSpecific(range.getBegin());
                    rangesIterator.remove();
                }
            }
            for (Definition definition : this.m_config.getDefinitionCollection()) {
                TreeMap<InetAddress, String> specificsMap = new TreeMap<InetAddress, String>((Comparator<InetAddress>)new InetAddressComparator());
                for (String specific : definition.getSpecificCollection()) {
                    specificsMap.put(InetAddressUtils.getInetAddress((String)specific), specific.trim());
                }
                TreeMap<InetAddress, Range> rangesMap = new TreeMap<InetAddress, Range>((Comparator<InetAddress>)new InetAddressComparator());
                for (Range range : definition.getRangeCollection()) {
                    rangesMap.put(InetAddressUtils.getInetAddress((String)range.getBegin()), range);
                }
                InetAddress priorSpecific = null;
                Range addedRange = null;
                for (InetAddress specific : specificsMap.keySet()) {
                    if (priorSpecific == null) {
                        priorSpecific = specific;
                        continue;
                    }
                    if (BigInteger.ONE.equals(InetAddressUtils.difference((InetAddress)specific, (InetAddress)priorSpecific)) && InetAddressUtils.inSameScope((InetAddress)specific, (InetAddress)priorSpecific)) {
                        if (addedRange == null) {
                            addedRange = new Range();
                            addedRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorSpecific));
                            rangesMap.put(priorSpecific, addedRange);
                            specificsMap.remove(priorSpecific);
                        }
                        addedRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific));
                        specificsMap.remove(specific);
                    } else {
                        addedRange = null;
                    }
                    priorSpecific = specific;
                }
                block10: for (InetAddress specific : new ArrayList(specificsMap.keySet())) {
                    for (InetAddress begin : new ArrayList(rangesMap.keySet())) {
                        Range range;
                        InetAddress end;
                        if (!InetAddressUtils.inSameScope((InetAddress)begin, (InetAddress)specific) || InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific)) > 0 || InetAddressUtils.toInteger((InetAddress)(end = InetAddressUtils.getInetAddress((String)(range = (Range)rangesMap.get(begin)).getEnd()))).add(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific)) < 0) continue;
                        if (InetAddressUtils.toInteger((InetAddress)specific).compareTo(InetAddressUtils.toInteger((InetAddress)begin)) >= 0 && InetAddressUtils.toInteger((InetAddress)specific).compareTo(InetAddressUtils.toInteger((InetAddress)end)) <= 0) {
                            specificsMap.remove(specific);
                            continue block10;
                        }
                        if (InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific))) {
                            rangesMap.remove(begin);
                            rangesMap.put(specific, range);
                            range.setBegin(InetAddressUtils.toIpAddrString((InetAddress)specific));
                            specificsMap.remove(specific);
                            continue block10;
                        }
                        if (!InetAddressUtils.toInteger((InetAddress)end).add(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific))) continue;
                        range.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific));
                        specificsMap.remove(specific);
                        continue block10;
                    }
                }
                Range priorRange = null;
                InetAddress priorBegin = null;
                InetAddress priorEnd = null;
                Iterator rangesIterator = rangesMap.keySet().iterator();
                while (rangesIterator.hasNext()) {
                    InetAddress beginAddress = (InetAddress)rangesIterator.next();
                    Range range = (Range)rangesMap.get(beginAddress);
                    InetAddress endAddress = InetAddressUtils.getInetAddress((String)range.getEnd());
                    if (priorRange != null && InetAddressUtils.inSameScope((InetAddress)beginAddress, priorEnd) && InetAddressUtils.difference((InetAddress)beginAddress, (InetAddress)priorEnd).compareTo(BigInteger.ONE) <= 0) {
                        priorBegin = new InetAddressComparator().compare(priorBegin, beginAddress) < 0 ? priorBegin : beginAddress;
                        priorRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorBegin));
                        priorEnd = new InetAddressComparator().compare(priorEnd, endAddress) > 0 ? priorEnd : endAddress;
                        priorRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)priorEnd));
                        rangesIterator.remove();
                        continue;
                    }
                    priorRange = range;
                    priorBegin = beginAddress;
                    priorEnd = endAddress;
                }
                definition.setSpecific(new ArrayList<String>(specificsMap.values()));
                definition.setRange(new ArrayList<Range>(rangesMap.values()));
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void setNSClientAgentConfig(NSClientAgentConfig agentConfig, Definition def) {
        this.setCommonAttributes(agentConfig, def);
        agentConfig.setPassword(this.determinePassword(def));
    }

    private void setCommonAttributes(NSClientAgentConfig agentConfig, Definition def) {
        agentConfig.setPort(this.determinePort(def));
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
    }

    private String determinePassword(Definition def) {
        return def.getPassword() == null ? (this.m_config.getPassword() == null ? "None" : this.m_config.getPassword()) : def.getPassword();
    }

    private int determinePort(Definition def) {
        return def.getPort() == 0 ? (this.m_config.getPort() == 0 ? 161 : this.m_config.getPort()) : def.getPort();
    }

    private long determineTimeout(Definition def) {
        return def.getTimeout() == 0 ? (this.m_config.getTimeout() == 0 ? 3000L : (long)this.m_config.getTimeout()) : (long)def.getTimeout();
    }

    private int determineRetries(Definition def) {
        return def.getRetry() == 0 ? (this.m_config.getRetry() == 0 ? 1 : this.m_config.getRetry()) : def.getRetry();
    }
}

