/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.capsd;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.protocols.nsclient.NsclientCheckParams;
import org.opennms.protocols.nsclient.NsclientException;
import org.opennms.protocols.nsclient.NsclientManager;
import org.opennms.protocols.nsclient.NsclientPacket;

public class NsclientPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "NSCLIENT";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        NsclientCheckParams params;
        NsclientPacket pack;
        int retries = 0;
        int timeout = 5000;
        int port = NsclientManager.DEFAULT_PORT;
        String password = "None";
        String parameter = null;
        String command = null;
        int critPerc = 0;
        int warnPerc = 0;
        if (qualifiers != null) {
            command = ParameterMap.getKeyedString(qualifiers, (String)"command", (String)NsclientManager.convertTypeToString("1"));
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)NsclientManager.DEFAULT_PORT);
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            parameter = ParameterMap.getKeyedString(qualifiers, (String)"parameter", null);
            critPerc = ParameterMap.getKeyedInteger(qualifiers, (String)"criticalPercent", (int)0);
            warnPerc = ParameterMap.getKeyedInteger(qualifiers, (String)"warningPercent", (int)0);
            password = ParameterMap.getKeyedString(qualifiers, (String)"password", (String)"None");
        }
        if ((pack = this.isServer(address, port, password, command, retries, timeout, params = new NsclientCheckParams(critPerc, warnPerc, parameter))) == null) {
            this.log().debug("Received a null packet response from isServer.");
            return false;
        }
        return pack.getResultCode() != 2 && pack.getResultCode() != -1;
    }

    private NsclientPacket isServer(InetAddress host, int port, String password, String command, int retries, int timeout, NsclientCheckParams params) {
        boolean isAServer = false;
        NsclientPacket response = null;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            try {
                NsclientManager client = new NsclientManager(InetAddressUtils.str((InetAddress)host), port, password);
                client.setTimeout(timeout);
                client.init();
                response = client.processCheckCommand(NsclientManager.convertStringToType(command), params);
                this.log().debug("NsclientPlugin: " + command + ": " + response.getResponse());
                isAServer = true;
                continue;
            }
            catch (NsclientException e) {
                StringBuffer message = new StringBuffer();
                message.append("NsclientPlugin: Check failed... NsclientManager returned exception: ");
                message.append(e.getMessage());
                message.append(" : ");
                message.append(e.getCause() == null ? "" : e.getCause().getMessage());
                this.log().info(message.toString());
                isAServer = false;
            }
        }
        return response;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

