/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dhcp.detector;

import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.opennms.protocols.dhcp.detector.client.DhcpClient;
import org.opennms.protocols.dhcp.detector.request.DhcpRequest;
import org.opennms.protocols.dhcp.detector.response.DhcpResponse;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DhcpDetector
extends BasicDetector<DhcpRequest, DhcpResponse> {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public DhcpDetector() {
        super("DHCP", 0);
        this.setTimeout(3000);
        this.setRetries(0);
    }

    protected void onInit() {
        this.expectBanner(this.responseTimeGreaterThan(-1L));
    }

    private ClientConversation.ResponseValidator<DhcpResponse> responseTimeGreaterThan(final long num) {
        return new ClientConversation.ResponseValidator<DhcpResponse>(){

            public boolean validate(DhcpResponse response) throws Exception {
                return response.validate(num);
            }
        };
    }

    protected Client<DhcpRequest, DhcpResponse> getClient() {
        DhcpClient client = new DhcpClient();
        client.setRetries(1);
        return client;
    }
}

