/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dhcp.detector.client;

import java.io.IOException;
import java.net.InetAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dhcpd.Dhcpd;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.protocols.dhcp.detector.request.DhcpRequest;
import org.opennms.protocols.dhcp.detector.response.DhcpResponse;

public class DhcpClient
implements Client<DhcpRequest, DhcpResponse> {
    private int m_retries;
    private int m_timeout;
    private InetAddress m_address;
    private long m_responseTime;

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.m_address = address;
        this.m_timeout = timeout;
    }

    public DhcpResponse receiveBanner() throws IOException, Exception {
        this.m_responseTime = Dhcpd.isServer(this.m_address, this.m_timeout, this.getRetries());
        ThreadCategory.getInstance(DhcpClient.class).debug("got a response from the server: " + this.m_responseTime);
        DhcpResponse response = new DhcpResponse(this.m_responseTime);
        return response;
    }

    public DhcpResponse sendRequest(DhcpRequest request) throws IOException, Exception {
        return null;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getRetries() {
        return this.m_retries;
    }
}

