/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dhcp.capsd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.dhcpd.Dhcpd;

public final class DhcpPlugin
extends AbstractPlugin {
    private static final Integer PORT_NUMBER = 67;
    private static final String PROTOCOL_NAME = "DHCP";
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    private boolean isServer(InetAddress host, int retries, int timeout) {
        boolean isAServer = false;
        long responseTime = -1L;
        try {
            responseTime = Dhcpd.isServer(host, timeout, retries);
        }
        catch (InterruptedIOException ioE) {
            ioE.fillInStackTrace();
            LogUtils.debugf((Object)((Object)this), (Throwable)ioE, (String)"isServer: The DHCP discovery operation was interrupted", (Object[])new Object[0]);
        }
        catch (IOException ioE) {
            LogUtils.warnf((Object)((Object)this), (Throwable)ioE, (String)"isServer: An I/O exception occured during DHCP discovery", (Object[])new Object[0]);
            isAServer = false;
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)((Object)this), (Throwable)t, (String)"isServer: An undeclared throwable exception was caught during test", (Object[])new Object[0]);
            isAServer = false;
        }
        if (responseTime >= 0L) {
            isAServer = true;
        }
        return isAServer;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress host) {
        return this.isServer(host, 3, 3000);
    }

    public boolean isProtocolSupported(InetAddress host, Map<String, Object> qualifiers) {
        boolean isAServer;
        int retries = 3;
        int timeout = 3000;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)3);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)3000);
        }
        if ((isAServer = this.isServer(host, retries, timeout)) && qualifiers != null) {
            qualifiers.put("port", PORT_NUMBER);
        }
        return isAServer;
    }
}

