/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFilenameFilter;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCifsMonitor
extends ParameterSubstitutingMonitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static String modeCandidates = "";
    private final Logger logger = LoggerFactory.getLogger(JCifsMonitor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        domain = JCifsMonitor.resolveKeyedString(parameters, (String)"domain", (String)"");
        username = JCifsMonitor.resolveKeyedString(parameters, (String)"username", (String)"");
        password = JCifsMonitor.resolveKeyedString(parameters, (String)"password", (String)"");
        mode = parameters.containsKey("mode") != false ? ((String)parameters.get("mode")).toUpperCase() : "PATH_EXIST";
        path = parameters.containsKey("path") != false ? (String)parameters.get("path") : "";
        smbHost = parameters.containsKey("smbHost") != false ? (String)parameters.get("smbHost") : "";
        v0 = folderIgnoreFiles = parameters.containsKey("folderIgnoreFiles") != false ? (String)parameters.get("folderIgnoreFiles") : "";
        if ("".equals(smbHost)) {
            smbHost = svc.getIpAddr();
        }
        smbFilenameFilter = new SmbFilenameFilter(){

            public boolean accept(SmbFile smbFile, String s) throws SmbException {
                return !s.matches(folderIgnoreFiles);
            }
        };
        enumMode = Mode.PATH_EXIST;
        try {
            enumMode = Mode.valueOf(mode);
        }
        catch (IllegalArgumentException exception) {
            this.logger.error("Mode '{}\u2018 does not exists. Valid candidates are {}", (Object)mode, (Object)JCifsMonitor.modeCandidates);
            return PollStatus.unknown((String)("Mode " + mode + " does not exists. Valid candidates are " + JCifsMonitor.modeCandidates));
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
            this.logger.debug("Added leading / to path.");
        }
        authString = "";
        if (domain != null && !"".equals(domain)) {
            authString = authString + domain + ";";
        }
        authString = authString + username + ":" + password;
        fullUrl = "smb://" + smbHost + path;
        this.logger.debug("Domain: [{}], Username: [{}], Password: [{}], Mode: [{}], Path: [{}], Authentication: [{}], Full Url: [{}]", new Object[]{domain, username, password, mode, path, authString, fullUrl});
        tracker = new TimeoutTracker(parameters, 0, 3000);
        baseCtx = null;
        jcifsProps = new Properties();
        connectionTimeoutAsStr = Integer.toString(tracker.getConnectionTimeout());
        jcifsProps.setProperty("jcifs.smb.client.soTimeout", connectionTimeoutAsStr);
        jcifsProps.setProperty("jcifs.smb.client.connTimeout", connectionTimeoutAsStr);
        jcifsProps.setProperty("jcifs.smb.client.responseTimeout", connectionTimeoutAsStr);
        jcifsProps.setProperty("jcifs.smb.client.sessionTimeout", connectionTimeoutAsStr);
        jcifsConfig = null;
        try {
            jcifsConfig = new PropertyConfiguration(jcifsProps);
            baseCtx = new BaseContext((Configuration)jcifsConfig);
        }
        catch (CIFSException cifse) {
            this.logger.warn("Unable to configure CIFS timeout properties due to {}. Using defaults.", (Object)cifse.getMessage());
            baseCtx = SingletonContext.getInstance();
        }
        authedCtx = baseCtx.withCredentials((Credentials)new NtlmPasswordAuthenticator(domain, username, password));
        serviceStatus = PollStatus.unknown((String)"unknown CIFS failure");
        try {
            tracker.reset();
            while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
                smbFile = null;
                try {
                    smbFile = new SmbFile(fullUrl, authedCtx);
                    smbFile.setConnectTimeout(tracker.getConnectionTimeout());
                    smbFileExists = smbFile.exists();
                    switch (2.$SwitchMap$org$opennms$netmgt$poller$monitors$JCifsMonitor$Mode[enumMode.ordinal()]) {
                        case 1: {
                            if (smbFileExists) {
                                serviceStatus = PollStatus.up();
                                ** break;
lbl62:
                                // 1 sources

                            } else {
                                serviceStatus = PollStatus.down((String)("File " + fullUrl + " should exists but doesn't!"));
                                ** break;
                            }
lbl65:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            if (!smbFileExists) {
                                serviceStatus = PollStatus.up();
                                ** break;
lbl70:
                                // 1 sources

                            } else {
                                serviceStatus = PollStatus.down((String)("File " + fullUrl + " should not exists but does!"));
                                ** break;
                            }
lbl73:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            if (smbFileExists) {
                                if (smbFile.list(smbFilenameFilter).length == 0) {
                                    serviceStatus = PollStatus.up();
                                    ** break;
lbl79:
                                    // 1 sources

                                } else {
                                    serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should be empty but isn't!"));
                                    ** break;
                                }
lbl82:
                                // 1 sources

                            } else {
                                serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should exists but doesn't!"));
                                ** break;
                            }
lbl85:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            if (smbFileExists) {
                                if (smbFile.list(smbFilenameFilter).length > 0) {
                                    serviceStatus = PollStatus.up();
                                    ** break;
lbl91:
                                    // 1 sources

                                } else {
                                    serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should not be empty but is!"));
                                    ** break;
                                }
lbl94:
                                // 1 sources

                            } else {
                                serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should exists but doesn't!"));
                                ** break;
                            }
lbl97:
                            // 1 sources

                            break;
                        }
                        default: {
                            this.logger.warn("There is no implementation for the specified mode '{}'", (Object)mode);
                            break;
                        }
                    }
                }
                catch (MalformedURLException exception) {
                    this.logger.error("Malformed URL on '{}' with error: '{}'", (Object)smbHost, (Object)exception.getMessage());
                    serviceStatus = PollStatus.down((String)exception.getMessage());
                }
                catch (SmbException exception) {
                    this.logger.error("SMB error on '{}' with error: '{}'", (Object)smbHost, (Object)exception.getMessage());
                    serviceStatus = PollStatus.down((String)exception.getMessage());
                }
                finally {
                    if (smbFile != null) {
                        try {
                            smbFile.close();
                        }
                        catch (Exception e) {
                            JCifsMonitor.LOG.warn("Unable to close {}", (Object)fullUrl, (Object)e);
                        }
                    }
                }
                tracker.nextAttempt();
            }
        }
        finally {
            this.closeContext(authedCtx);
            this.closeContext((CIFSContext)baseCtx);
        }
        return serviceStatus;
    }

    private void closeContext(CIFSContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close CIFS context", (Throwable)e);
            }
        }
    }

    static {
        for (Mode m : Mode.values()) {
            if (!"".equals(modeCandidates)) {
                modeCandidates = modeCandidates + ", ";
            }
            modeCandidates = modeCandidates + (Object)((Object)m);
        }
    }

    private static enum Mode {
        PATH_EXIST,
        PATH_NOT_EXIST,
        FOLDER_EMPTY,
        FOLDER_NOT_EMPTY;

    }
}

