/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productpub.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.productpub.ProductPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="product-pub", name="removeproductspec", description="Removes product specification from product publisher")
public class RemoveProductSpecCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveProductSpecCommand.class);
    private ProductPublisher productPublisher = null;
    @Argument(index=0, name="productId", description="Product Id to remove product information", required=true, multiValued=false)
    String productId = null;

    public ProductPublisher getProductPublisher() {
        return this.productPublisher;
    }

    public void setProductPublisher(ProductPublisher productPublisher) {
        this.productPublisher = productPublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            if (this.getProductPublisher().removeProductDescription(this.productId)) {
                System.out.println("Removed description for productId=" + this.productId);
                LOG.info("Removed description for productId=" + this.productId);
            } else {
                System.out.println("No product description installed for productId='" + this.productId + "'");
                LOG.info("No product description installed for productId='" + this.productId + "'");
            }
        }
        catch (Exception e) {
            System.err.println("Error removing product description for productId. Exception=" + e);
            LOG.error("Error removing product description for productId. Exception=", (Throwable)e);
        }
        return null;
    }
}

