/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="checksumforstring", description="Creates and adds a checksum to a given string")
public class ChecksumForStringCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumForStringCommand.class);
    private LicenceService _licenceService;
    @Argument(index=0, name="string", description="simple string to add checksum.", required=true, multiValued=false)
    String string = null;

    public LicenceService getLicenceService() {
        return this._licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this._licenceService = licenceService;
    }

    protected Object doExecute() throws Exception {
        try {
            String stringPlusChecksum = this.getLicenceService().checksumForString(this.string);
            System.out.println("string plus checksum='" + stringPlusChecksum + "'");
            LOG.info("string plus checksum='" + stringPlusChecksum + "'");
        }
        catch (Exception e) {
            System.err.println("Error Adding Checksum. Exception=" + e);
            LOG.error("Error Adding Checksum. Exception=", (Throwable)e);
        }
        return null;
    }
}

