/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.metadata.Licence;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="addlicence", description="Adds licence for productId")
public class AddLicenceCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AddLicenceCommand.class);
    private LicenceService _licenceService;
    @Argument(index=0, name="licence", description="encoded licence string including productId", required=true, multiValued=false)
    String licence = null;

    public LicenceService getLicenceService() {
        return this._licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this._licenceService = licenceService;
    }

    protected Object doExecute() throws Exception {
        try {
            String productId = Licence.getUnverifiedMetadata(this.licence).getProductId();
            LicenceMetadata licenceMetadata = this.getLicenceService().addLicence(this.licence);
            String metadatastr = licenceMetadata == null ? "null" : licenceMetadata.toXml();
            String msg = "Added licence ProductId='" + productId + "'" + "\n              licence=  '" + this.licence + "'" + "\n              licenceMetadata='" + metadatastr + "'\n";
            LOG.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            System.err.println("Error Adding licence. Exception=" + e);
            LOG.error("Error Adding licence. Exception=", (Throwable)e);
        }
        return null;
    }
}

