/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import org.opennms.karaf.licencemgr.AesSymetricKeyCipher;
import org.opennms.karaf.licencemgr.ClientKeys;
import org.opennms.karaf.licencemgr.PublisherKeys;
import org.opennms.karaf.licencemgr.RsaAsymetricKeyCipher;

public class GeneratedKeys
implements ClientKeys,
PublisherKeys {
    private final String aesSecretKeyStr;
    private final String privateKeyStr;
    private final String publicKeyStr;
    private final String privateKeyEnryptedStr;

    public GeneratedKeys() {
        AesSymetricKeyCipher aesCipher = new AesSymetricKeyCipher();
        aesCipher.generateKey();
        this.aesSecretKeyStr = aesCipher.getEncodedSecretKeyStr();
        RsaAsymetricKeyCipher rsaAsymetricKeyCipher = new RsaAsymetricKeyCipher();
        rsaAsymetricKeyCipher.generateKeys();
        this.privateKeyStr = rsaAsymetricKeyCipher.getPrivateKeyStr();
        this.publicKeyStr = rsaAsymetricKeyCipher.getPublicKeyStr();
        this.privateKeyEnryptedStr = aesCipher.aesEncryptStr(this.privateKeyStr);
    }

    public String getPrivateKeyStr() {
        return this.privateKeyStr;
    }

    @Override
    public String getPublicKeyStr() {
        return this.publicKeyStr;
    }

    @Override
    public String getAesSecretKeyStr() {
        return this.aesSecretKeyStr;
    }

    @Override
    public String getPrivateKeyEnryptedStr() {
        return this.privateKeyEnryptedStr;
    }

    public PublisherKeys makePublisherKeys() {
        final String aesSecret = this.aesSecretKeyStr;
        final String pubKeyStr = this.publicKeyStr;
        return new PublisherKeys(){
            private final String aesSecretKeyStr;
            private final String publicKeyStr;
            {
                this.aesSecretKeyStr = aesSecret;
                this.publicKeyStr = pubKeyStr;
            }

            @Override
            public String getAesSecretKeyStr() {
                return this.aesSecretKeyStr;
            }

            @Override
            public String getPublicKeyStr() {
                return this.publicKeyStr;
            }
        };
    }

    public ClientKeys makeClientKeys() {
        final String privKeyEnryptedStr = this.privateKeyEnryptedStr;
        return new ClientKeys(){
            private final String privateKeyEnryptedStr;
            {
                this.privateKeyEnryptedStr = privKeyEnryptedStr;
            }

            @Override
            public String getPrivateKeyEnryptedStr() {
                return this.privateKeyEnryptedStr;
            }
        };
    }
}

