/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemanager.generate;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.opennms.karaf.licencemanager.generate.LicenceArtifactsGenerator;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductSpecList;

public class ProductSpecListGenerator {
    private static final String PRODUCT_SPEC_FILENAME = "productSpec.xml";
    private String outputFile = null;
    private String searchDirectory = null;
    private String packagingDescriptor = null;

    public ProductSpecListGenerator(String searchDirectory, String outputFile, String packagingDescriptor) {
        this.outputFile = outputFile;
        this.searchDirectory = searchDirectory;
        this.packagingDescriptor = packagingDescriptor;
        this.generateProductSpecList();
    }

    public void generateProductSpecList() {
        System.out.println("Generating product specifications list for productSpec.xml product definitions contained in jars\n  search directory=" + this.searchDirectory + "\n  output file=" + this.outputFile);
        ArrayList<File> files = new ArrayList<File>();
        this.findFiles(this.searchDirectory, ".jar", files);
        ProductSpecList productSpecList = new ProductSpecList();
        System.out.println("Discovering product spec in jar files");
        for (File f : files) {
            System.out.println("   searching " + f.getAbsolutePath());
            ZipFile jarFile = null;
            InputStream is = null;
            try {
                jarFile = new ZipFile(f);
                ZipEntry arg = jarFile.getEntry(PRODUCT_SPEC_FILENAME);
                if (arg != null) {
                    System.out.println("   found " + arg.getName());
                    is = jarFile.getInputStream(arg);
                    String productMetadataXml = this.readFile(is);
                    ProductMetadata productMetadata = new ProductMetadata();
                    if (this.packagingDescriptor != null) {
                        productMetadata.setPackageingDescriptor(this.packagingDescriptor);
                    }
                    productMetadata.fromXml(productMetadataXml);
                    System.out.println("       productName=" + productMetadata.getProductName());
                    System.out.println("       productId=" + productMetadata.getProductId());
                    System.out.println("       featureRepository=" + productMetadata.getFeatureRepository());
                    System.out.println("       packagingDescriptor=" + productMetadata.getPackageingDescriptor());
                    productSpecList.getProductSpecList().add(productMetadata);
                } else {
                    System.out.println("   no productSpec.xml in:" + f.getAbsolutePath());
                }
                if (this.packagingDescriptor != null) {
                    productSpecList.setProductListSource(this.packagingDescriptor);
                }
                System.out.println("   productListSource=" + productSpecList.getProductListSource());
            }
            catch (Exception e) {
                throw new RuntimeException("   problem reading productSpec.xml in:" + f.getAbsolutePath(), e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (jarFile == null) continue;
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        try (PrintWriter out = null;){
            String productSpecStr = productSpecList.toXml(true);
            System.out.println("final product specification :\n" + productSpecStr);
            File outfile = new File(this.outputFile);
            File absoutfile = outfile.getAbsoluteFile();
            System.out.println("writing product specification to file :\n" + absoutfile.getAbsolutePath());
            absoutfile.getParentFile().mkdirs();
            out = new PrintWriter(absoutfile);
            out.println(productSpecStr);
        }
        System.out.println("completed writing product spec list to " + this.outputFile);
    }

    private String readFile(InputStream is) {
        String str = null;
        try (Scanner s = null;){
            s = new Scanner(is, "UTF-8").useDelimiter("\\A");
            str = s.hasNext() ? s.next() : "";
        }
        return str;
    }

    private void findFiles(String directoryName, String fileSuffix, ArrayList<File> files) {
        File[] fList;
        File directory = new File(directoryName);
        if (!directory.getAbsoluteFile().exists()) {
            throw new IllegalArgumentException("directoryName " + directoryName + " does not exist. File path=" + directory.getAbsolutePath());
        }
        if (!directory.getAbsoluteFile().isDirectory()) {
            throw new IllegalArgumentException("directoryName " + directoryName + " is not a directory. File path=" + directory.getAbsolutePath());
        }
        for (File file : fList = directory.getAbsoluteFile().listFiles()) {
            if (file.isFile()) {
                if (!file.getName().endsWith(fileSuffix)) continue;
                files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.findFiles(file.getAbsolutePath(), fileSuffix, files);
        }
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getSearchDirectory() {
        return this.searchDirectory;
    }

    public void setSearchDirectory(String searchDirectory) {
        this.searchDirectory = searchDirectory;
    }

    public static void main(String[] args) {
        System.out.println(ProductSpecListGenerator.class.getName() + " Starting to generate Available Plugins List for Kar ");
        try {
            if (args.length != 3 && args.length != 2) {
                throw new IllegalArgumentException(ProductSpecListGenerator.class.getName() + " Has wrong number of arguments");
            }
            String searchDirectory = args[0];
            String outputFile = args[1];
            String packagingDescriptor = args[2];
            ProductSpecListGenerator test = new ProductSpecListGenerator(searchDirectory, outputFile, packagingDescriptor);
            System.out.println(LicenceArtifactsGenerator.class.getName() + " Available Plugins List Generated");
        }
        catch (Exception e) {
            System.err.println(LicenceArtifactsGenerator.class.getName() + " Problem Generating Available Plugins List: ");
            System.err.println("Correct usage: java args[0] = searchDirectory; args[1]=outputFile; args[3]=packagingDescriptor (optional)\nError: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

