/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemanager.generate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.opennms.karaf.licencemgr.GeneratedKeys;

public class LicenceArtifactsGenerator {
    private static final String licenceSpecClassName = "BundleLocalLicenceSpecImpl";
    private static final String licenceAuthenticatorClassName = "BundleLicenceAuthenticatorImpl";
    private static final String licenceAuthenticatorInterfaceName = "BundleLicenceAuthenticator";
    private String basePackage = null;
    private String productId = null;
    private String outputDirectory = null;
    private String aesSecretKeyStr = null;
    private String publicKeyStr = null;
    String privateKeyStr = null;
    String privateKeyEnryptedStr = null;
    private String javaOutputDirectory = null;
    private String resourcesOutputDirectory = null;
    private String productIdHash = null;

    public LicenceArtifactsGenerator(String productId, String basePackage, String outputDirectory) {
        if (basePackage == null) {
            throw new IllegalArgumentException("basePackage cannot be null");
        }
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        if (outputDirectory == null) {
            throw new IllegalArgumentException("outputDirectory cannot be null");
        }
        this.basePackage = basePackage;
        this.productId = productId;
        this.outputDirectory = outputDirectory;
        this.javaOutputDirectory = outputDirectory + "/java";
        this.resourcesOutputDirectory = outputDirectory + "/resources";
        this.productIdHash = "x" + Integer.toHexString(productId.hashCode());
        this.generateLicenceKeys();
        this.generateLicenceSpec();
        this.generateLicenceAuthenticator();
        this.generateProductDescriptor();
    }

    private void generateLicenceKeys() {
        GeneratedKeys generatedKeys = new GeneratedKeys();
        this.aesSecretKeyStr = generatedKeys.getAesSecretKeyStr();
        this.privateKeyEnryptedStr = generatedKeys.getPrivateKeyEnryptedStr();
        this.privateKeyStr = generatedKeys.getPrivateKeyStr();
        this.publicKeyStr = generatedKeys.getPublicKeyStr();
        System.out.println("Generated Keys  aesSecretKeyStr      =" + this.aesSecretKeyStr);
        System.out.println("Generated Keys  privateKeyStr        =" + this.privateKeyStr);
        System.out.println("Generated Keys  privateKeyEnryptedStr=" + this.privateKeyEnryptedStr);
        System.out.println("Generated Keys  publicKeyStrr        =" + this.publicKeyStr);
    }

    private void generateLicenceSpec() {
        String licenceSpecClassFileName = "BundleLocalLicenceSpecImpl.java";
        String licenceSpecPackage = this.basePackage + ".licence." + this.productIdHash;
        String licenceSpecFileDirectory = licenceSpecPackage.replace('.', File.separatorChar);
        String licenceSpecClassStr = "\npackage " + licenceSpecPackage + ";\n" + "\n" + "import org.opennms.karaf.licencemgr.BundleLicenceSpec;\n" + "import org.opennms.karaf.licencemgr.BundleLicenceSpecImpl;\n" + "import org.opennms.karaf.licencepub.LicencePublisher;\n" + "import org.osgi.framework.BundleContext;\n" + "import org.slf4j.Logger;\n" + "import org.slf4j.LoggerFactory;\n" + "\n" + "/**\n" + " *  Generated Licence Specification Class\n" + " *  for productId=" + this.productId + "\n" + " */\n" + "public class " + licenceSpecClassName + " {\n" + "    private static final Logger LOG = LoggerFactory.getLogger(" + licenceSpecClassName + ".class);\n" + "\n" + "    private static final String productId=\"" + this.productId + "\";\n" + "\n" + "    private static final String aesSecretKeyStr=\"" + this.aesSecretKeyStr + "\";\n" + "    private static final String publicKeyStr=\"" + this.publicKeyStr + "\";\n" + "\n" + "    private BundleLicenceSpec bundleLicenceSpec=null;\n" + "    \n" + "    public BundleLocalLicenceSpecImpl( LicencePublisher licencePublisher, BundleContext bundleContext, String licenceMetadataUri){\n" + "        bundleLicenceSpec = new BundleLicenceSpecImpl(licencePublisher, bundleContext, productId, licenceMetadataUri,  aesSecretKeyStr, publicKeyStr);\n" + "    }\n" + "    \n" + "\n" + "    //use as blueprint destroy-method\n" + "    public void unregisterSpec(){\n" + "        if (bundleLicenceSpec!=null){\n" + "            try{\n" + "                bundleLicenceSpec.unregisterSpec();\n" + "                System.out.println(BundleLocalLicenceSpecImpl.class +\": Unregistered Licence Specification for productId=\"+productId);\n" + "                LOG.info(BundleLocalLicenceSpecImpl.class +\": Unregistered Licence Specification for productId=\"+productId);\n" + "            } catch (Exception e){\n" + "                System.err.println(BundleLocalLicenceSpecImpl.class +\": Problem Unregistering Licence Specification for productId=\"+productId+\"  \"+ e);\n" + "                LOG.error(BundleLocalLicenceSpecImpl.class +\": Problem Unregistering Licence Specification for productId=\"+productId+\"  \", e);\n" + "            }  finally {\n" + "                bundleLicenceSpec=null; //release resources\n" + "            }\n" + "        }\n" + "    }\n" + "}\n" + "";
        this.writeFile(this.javaOutputDirectory, licenceSpecFileDirectory, licenceSpecClassFileName, licenceSpecClassStr);
        String licenceSpecBlueprintStr = "<blueprint xmlns=\"http://www.osgi.org/xmlns/blueprint/v1.0.0\">\n\n    <!-- Generated Licence Specification Blueprint-->\n    <!-- for productId='" + this.productId + "' -->\n" + "\n" + "    <reference id=\"productPublisher\" interface=\"org.opennms.karaf.productpub.ProductPublisher\"\n" + "        timeout=\"10000\" />\n" + "\n" + "    <bean id=\"localBundleProductSpec\" class=\"org.opennms.karaf.productpub.BundleProductSpecImpl\"\n" + "        init-method=\"registerSpec\" destroy-method=\"unregisterSpec\">\n" + "        <property name=\"bundleContext\" ref=\"blueprintBundleContext\"></property>\n" + "        <property name=\"productPublisher\" ref=\"productPublisher\"></property>\n" + "        <property name=\"productMetadataUri\" value=\"/productSpec.xml\"></property>\n" + "    </bean>\n" + "\n" + "    <reference id=\"licencePublisher\" interface=\"org.opennms.karaf.licencepub.LicencePublisher\"\n" + "        timeout=\"10000\" />\n" + "\n" + "    <!-- BundleLocalLicenceSpecImpl(LicencePublisher licencePublisher, BundleContext bundleContext, String licenceMetadataUri -->\n" + "    <bean id=\"localBundleLicenceSpec\"\n" + "        class=\"" + licenceSpecPackage + "." + licenceSpecClassName + "\"\n" + "        destroy-method=\"unregisterSpec\">\n" + "        <argument index=\"0\" ref=\"licencePublisher\" />\n" + "        <argument index=\"1\" ref=\"blueprintBundleContext\" />\n" + "        <argument index=\"2\" value=\"/licenceMetadataSpec.xml\" />\n" + "    </bean>\n" + "\n" + "</blueprint>\n";
        this.writeFile(this.resourcesOutputDirectory, "OSGI-INF/blueprint", "licenceSpecBlueprint.xml", licenceSpecBlueprintStr);
    }

    private void generateLicenceAuthenticator() {
        String licenceAuthenticatorClassFileName = "BundleLicenceAuthenticatorImpl.java";
        String licenceAuthenticatorInterfaceFileName = "BundleLicenceAuthenticator.java";
        String licenceAuthenticatorPackage = this.basePackage + ".authenticator." + this.productIdHash;
        String licenceAuthenticatorFileDirectory = licenceAuthenticatorPackage.replace('.', File.separatorChar);
        String licenceAuthenticatorClassStr = "package " + licenceAuthenticatorPackage + ";  \n" + "  \n" + "import org.opennms.karaf.licencemgr.LicenceAuthenticatorImpl;  \n" + "import org.opennms.karaf.licencemgr.LicenceService;  \n" + "import " + licenceAuthenticatorPackage + "." + licenceAuthenticatorInterfaceName + ";  \n" + "  \n" + "/**\n" + " *   Generated Licence Authenticator Class\n" + " *   for productId=" + this.productId + "\n" + " */\n" + "public class " + licenceAuthenticatorClassName + " extends LicenceAuthenticatorImpl implements " + licenceAuthenticatorInterfaceName + " {  \n" + "  \n" + "    private static final String productId=\"" + this.productId + "\";\n" + "    final static String privateKeyEnryptedStr=\"" + this.privateKeyEnryptedStr + "\";  \n" + "  \n" + "    // constructor to authenticate against the licence stored in the manager\n" + "    public BundleLicenceAuthenticatorImpl(LicenceService licenceService) {  \n" + "        super(licenceService, productId, privateKeyEnryptedStr);  \n" + "    }  \n" + "  \n" + "    // constructor to authenticate an externally supplied licence string\n" + "    public BundleLicenceAuthenticatorImpl(String licencewithCRC) {  \n" + "        super (licencewithCRC, productId, privateKeyEnryptedStr );  \n" + "    }  \n" + "  \n" + "}  \n";
        this.writeFile(this.javaOutputDirectory, licenceAuthenticatorFileDirectory, licenceAuthenticatorClassFileName, licenceAuthenticatorClassStr);
        String licenceAuthenticatorInterfaceStr = "package " + licenceAuthenticatorPackage + ";  \n" + "  \n" + "/**\n" + " *   Generated Licence Authenticator Interface\n" + " *   for productId=" + this.productId + "\n" + " */\n" + "public interface " + licenceAuthenticatorInterfaceName + " extends org.opennms.karaf.licencemgr.BundleLicenceAuthenticator {  \n" + "  \n" + "}  \n";
        this.writeFile(this.javaOutputDirectory, licenceAuthenticatorFileDirectory, licenceAuthenticatorInterfaceFileName, licenceAuthenticatorInterfaceStr);
        String licenceAuthenticatorBlueprintStr = "<blueprint xmlns=\"http://www.osgi.org/xmlns/blueprint/v1.0.0\">\n\n  <!-- Generated Licence Authenticator Blueprint-->\n  <!-- for productId='" + this.productId + "' -->\n" + "\n" + "  <!-- check licence with licence service -->\n" + "  <reference id=\"licenceService\" interface=\"org.opennms.karaf.licencemgr.LicenceService\" timeout=\"10000\" />\n" + "\n" + "  <bean id=\"licenceAuthenticator\" class=\"" + licenceAuthenticatorPackage + "." + licenceAuthenticatorClassName + "\" destroy-method=\"destroyMethod\">\n" + "    <argument ref=\"licenceService\" />\n" + "  </bean>\n" + "\n" + "</blueprint>\n" + "";
        this.writeFile(this.resourcesOutputDirectory, "OSGI-INF/blueprint", "licenceAuthenticatorBlueprint.xml", licenceAuthenticatorBlueprintStr);
    }

    private void generateProductDescriptor() {
        String productDescriptorBlueprintStr = "<blueprint xmlns=\"http://www.osgi.org/xmlns/blueprint/v1.0.0\">\n\n  <!-- register product information with product registry -->\n  <reference id=\"productRegister\" interface=\"org.opennms.karaf.productpub.ProductRegister\" timeout=\"10000\" />\n\n  <bean id=\"localBundleProductDescription\" class=\"org.opennms.karaf.productpub.BundleProductSpecImpl\" init-method=\"registerSpec\" destroy-method=\"unregisterSpec\">\n    <property name=\"bundleContext\" ref=\"blueprintBundleContext\"></property>\n    <property name=\"productPublisher\" ref=\"productRegister\"></property>\n    <property name=\"productMetadataUri\" value=\"/productSpec.xml\"></property>\n  </bean>\n\n</blueprint>\n";
        this.writeFile(this.resourcesOutputDirectory, "OSGI-INF/blueprint", "productDescriptorBlueprint.xml", productDescriptorBlueprintStr);
    }

    private void writeFile(String outputDirectory, String relativePathDirectory, String fileName, String fileContents) {
        Writer writer = null;
        try {
            File outDir = new File(outputDirectory);
            outDir.mkdirs();
            File fileDir = new File(outDir, relativePathDirectory);
            fileDir.mkdirs();
            File file = new File(fileDir, fileName);
            FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsoluteFile());
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8"));
            writer.write(fileContents);
            writer.close();
            System.out.println("file '" + fileName + "' written to " + file.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write java file. ", ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        System.out.println(LicenceArtifactsGenerator.class.getName() + " Starting to generate Licence Artifacts");
        if (args.length != 3) {
            throw new IllegalArgumentException(LicenceArtifactsGenerator.class.getName() + " Has wrong number of arguments");
        }
        String productId = args[0];
        String basePackage = args[1];
        String outputDirectory = args[2];
        LicenceArtifactsGenerator licenceArtifactsGenerator = new LicenceArtifactsGenerator(productId, basePackage, outputDirectory);
        System.out.println(LicenceArtifactsGenerator.class.getName() + " Licence Artifacts Generated");
    }
}

