/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencepub.cmd;

import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencepub.LicencePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-pub", name="listspecs", description="Lists installed licence specifications")
public class ListLicenceSpecsCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ListLicenceSpecsCommand.class);
    private LicencePublisher _licencePublisher;

    public LicencePublisher getLicencePublisher() {
        return this._licencePublisher;
    }

    public void setLicencePublisher(LicencePublisher _licencePublisher) {
        this._licencePublisher = _licencePublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            System.out.println("list of licence specifications");
            LOG.info("list of licence specifications");
            Map<String, LicenceSpecification> licenceSpecMap = this.getLicencePublisher().getLicenceSpecMap();
            for (Map.Entry<String, LicenceSpecification> entry : licenceSpecMap.entrySet()) {
                LicenceSpecification licenceSpecification = entry.getValue();
                LicenceMetadata licenceMetadata = licenceSpecification.getLicenceMetadataSpec();
                String msg = "***********\n  productId='" + entry.getKey() + "'\n" + "  licenceMetadataSpec='" + licenceMetadata.toXml() + "'\n" + "  licenceSpecification secret key String='" + licenceSpecification.getAesSecretKeyStr() + "'\n" + "  licenceSpecification public key String='" + licenceSpecification.getPublicKeyStr() + "'\n";
                System.out.println(msg);
                LOG.info(msg);
            }
            System.out.println("***********\n");
            LOG.info("***********\n");
        }
        catch (Exception e) {
            System.out.println("Error getting list of installed licence specifications. Exception=" + e);
            LOG.error("Error getting list of installed licence specifications. Exception=", (Throwable)e);
        }
        return null;
    }
}

