/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencepub.cmd;

import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencepub.LicencePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-pub", name="list", description="Lists licence metadata for installed licence specifications (i.e. not the keys)")
public class ListLicenceMetadataCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ListLicenceMetadataCommand.class);
    private LicencePublisher _licencePublisher;

    public LicencePublisher getLicencePublisher() {
        return this._licencePublisher;
    }

    public void setLicencePublisher(LicencePublisher _licencePublisher) {
        this._licencePublisher = _licencePublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            System.out.println("List of licence metadata for installed licence specifications:");
            LOG.info("List of licence metadata for installed licence specifications:");
            Map<String, LicenceSpecification> licenceSpecMap = this.getLicencePublisher().getLicenceSpecMap();
            for (Map.Entry<String, LicenceSpecification> entry : licenceSpecMap.entrySet()) {
                LicenceSpecification licenceSpecification = entry.getValue();
                LicenceMetadata licenceMetadata = licenceSpecification.getLicenceMetadataSpec();
                String msg = "***********\n  productId='" + entry.getKey() + "'\n" + "  licenceMetadataSpec='" + licenceMetadata.toXml() + "'\n";
                System.out.println(msg);
                LOG.info(msg);
            }
            System.out.println("***********\n");
            LOG.info("***********\n");
        }
        catch (Exception e) {
            System.err.println("Error getting list of licence metadata for installed licence specifications. Exception=" + e);
            LOG.error("Error getting list of licence metadata for installed licence specifications. Exception=", (Throwable)e);
        }
        return null;
    }
}

