/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.rest.impl;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.karaf.licencemgr.metadata.jaxb.ErrorMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductSpecList;
import org.opennms.karaf.licencemgr.metadata.jaxb.ReplyMessage;
import org.opennms.karaf.licencemgr.rest.ProductRegisterRest;
import org.opennms.karaf.licencemgr.rest.impl.ServiceLoader;
import org.opennms.karaf.productpub.ProductRegister;

@Path(value="/product-reg")
public class ProductRegisterRestImpl
implements ProductRegisterRest {
    @Override
    @POST
    @Path(value="/addproductspec")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response addProductDescription(ProductMetadata productMetadata) {
        ProductRegister productRegister = ServiceLoader.getProductRegister();
        if (productRegister == null) {
            throw new RuntimeException("ServiceLoader.getProductRegister cannot be null.");
        }
        try {
            if (productMetadata == null) {
                throw new RuntimeException("productMetadata cannot be null.");
            }
            productRegister.addProductDescription(productMetadata);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to add product description", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Product Description added for productId=" + productMetadata.getProductId());
        reply.setProductId(productMetadata.getProductId());
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/removeproductspec")
    @Produces(value={"application/xml"})
    public Response removeProductDescription(@QueryParam(value="productId") String productId) {
        ProductRegister productRegister = ServiceLoader.getProductRegister();
        if (productRegister == null) {
            throw new RuntimeException("ServiceLoader.getProductRegister cannot be null.");
        }
        Boolean removed = null;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            removed = productRegister.removeProductDescription(productId);
            String devMessage = null;
            if (!removed.booleanValue()) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Product Description not found to remove for productId=" + productId, null, devMessage)).build();
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to remove product description", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Product Description removed for productId=" + productId);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/getproductspec")
    @Produces(value={"application/xml"})
    public Response getProductDescription(@QueryParam(value="productId") String productId) {
        ProductRegister productRegister = ServiceLoader.getProductRegister();
        if (productRegister == null) {
            throw new RuntimeException("ServiceLoader.getProductRegister cannot be null.");
        }
        ProductMetadata productDescription = null;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            productDescription = productRegister.getProductDescription(productId);
            String devMessage = null;
            if (productDescription == null) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "productDescription not found for productId=" + productId, null, devMessage)).build();
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to get product description", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Product Description found for productId=" + productId);
        reply.setProductMetadata(productDescription);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/list")
    @Produces(value={"application/xml"})
    public Response getProductDescriptionList() {
        ProductRegister productRegister = ServiceLoader.getProductRegister();
        if (productRegister == null) {
            throw new RuntimeException("ServiceLoader.getProductRegister cannot be null.");
        }
        Map<String, ProductMetadata> productDescrMap = null;
        try {
            productDescrMap = productRegister.getProductDescriptionMap();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to get product description map", null, exception)).build();
        }
        ProductSpecList productSpecList = new ProductSpecList();
        productSpecList.getProductSpecList().addAll(productDescrMap.values());
        return Response.status((int)200).entity((Object)productSpecList).build();
    }

    @Override
    @GET
    @Path(value="/clearproductspecs")
    @Produces(value={"application/xml"})
    public Response deleteProductDescriptions(@QueryParam(value="confirm") String confirm) {
        ProductRegister productRegister = ServiceLoader.getProductRegister();
        if (productRegister == null) {
            throw new RuntimeException("ServiceLoader.getProductRegister cannot be null.");
        }
        try {
            if (!"true".equals(confirm)) {
                throw new IllegalArgumentException("Will only delete specs if paramater confirm=true");
            }
            productRegister.deleteProductDescriptions();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to delete product descriptions", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("All Product Specifications removed");
        return Response.status((int)200).entity((Object)reply).build();
    }
}

