/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.rest.client.jerseyimpl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import javax.ws.rs.core.MediaType;
import org.opennms.karaf.licencemgr.metadata.jaxb.ErrorMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductSpecList;
import org.opennms.karaf.licencemgr.metadata.jaxb.ReplyMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.Util;
import org.opennms.karaf.licencemgr.rest.client.ProductPublisherClient;

public class ProductPublisherClientRestJerseyImpl
implements ProductPublisherClient {
    private String baseUrl = "http://localhost:8181";
    private String basePath = "/licencemgr/rest/v1-0/product-pub";
    private String userName = null;
    private String password = "";

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new RuntimeException("password must not be set to null");
        }
        this.password = password;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private Client newClient() {
        Client client = Client.create();
        if (this.userName != null) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.userName, this.password));
        }
        return client;
    }

    @Override
    public void addProductSpec(ProductMetadata productMetadata) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productMetadata == null) {
            throw new RuntimeException("productMetadata must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/addproductspec");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/xml")).post(ClientResponse.class, (Object)productMetadata);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public void removeProductSpec(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/removeproductspec?productId=" + productId);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "removeProductSpec Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }

    @Override
    public ProductMetadata getProductSpec(String productId) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (productId == null) {
            throw new RuntimeException("productId must be set");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/getproductspec?productId=" + productId);
        ReplyMessage replyMessage = (ReplyMessage)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(ReplyMessage.class);
        if (replyMessage.getProductMetadata() == null) {
            throw new RuntimeException("unable to get product metadata for productId=" + productId + " replyMessage.getReplyComment()=" + replyMessage.getReplyComment());
        }
        return replyMessage.getProductMetadata();
    }

    @Override
    public ProductSpecList getList() throws Exception {
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        Client client = this.newClient();
        String getStr = this.baseUrl + this.basePath + "/list";
        WebResource r = client.resource(getStr);
        String replyString = (String)((WebResource.Builder)r.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new String[]{"application/xml"})).get(String.class);
        ProductSpecList productSpecList = null;
        Object replyObject = Util.fromXml(replyString);
        if (!(replyObject instanceof ProductSpecList)) {
            throw new RuntimeException("received unexpected reply object: " + replyObject.getClass().getCanonicalName());
        }
        productSpecList = (ProductSpecList)replyObject;
        return productSpecList;
    }

    @Override
    public void clearProductSpecs(Boolean confirm) throws Exception {
        String getStr;
        if (this.baseUrl == null || this.basePath == null) {
            throw new RuntimeException("basePath and baseUrl must both be set");
        }
        if (confirm == null) {
            throw new RuntimeException("confirm must be set true of false");
        }
        Client client = this.newClient();
        WebResource r = client.resource(getStr = this.baseUrl + this.basePath + "/clearproductspecs?confirm=" + (confirm != false ? "true" : "false"));
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.accept(new String[]{"application/xml"}).type("application/x-www-form-urlencoded")).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            ErrorMessage errorMessage = null;
            try {
                errorMessage = (ErrorMessage)response.getEntity(ErrorMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = "clearProductSpecs Failed : HTTP error code : " + response.getStatus();
            if (errorMessage != null) {
                errMsg = errMsg + " message:" + errorMessage.getMessage() + " code:" + errorMessage.getCode() + " developer message:" + errorMessage.getDeveloperMessage();
            }
            throw new RuntimeException(errMsg);
        }
    }
}

