/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="isauthenticated", description="Checks if licence has been authenticated when starting productId")
public class IsAuthenticatedProductIdCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(IsAuthenticatedProductIdCommand.class);
    private LicenceService _licenceService;
    @Argument(index=0, name="productId", description="productId to be checked if licence authenticated", required=true, multiValued=false)
    String productId = null;

    public LicenceService getLicenceService() {
        return this._licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this._licenceService = licenceService;
    }

    protected Object doExecute() throws Exception {
        try {
            if (this.getLicenceService().isAuthenticatedProductId(this.productId)) {
                System.out.println("Licence Authenticated for ProductId='" + this.productId + "'");
                LOG.info("Licence Authenticated for ProductId='" + this.productId + "'");
            } else {
                System.out.println("Licence Not Authenticated for ProductId='" + this.productId + "'");
                LOG.info("Licence Not Authenticated for ProductId='" + this.productId + "'");
                if (this.getLicenceService().getLicence(this.productId) == null) {
                    System.out.println("No Licence installed for ProductId='" + this.productId + "'");
                    LOG.info("No Licence installed for ProductId='" + this.productId + "'");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error Checking Licence for productId. Exception=" + e);
            LOG.error("Error Checking Licence for productId. Exception=", (Throwable)e);
        }
        return null;
    }
}

