/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.metadata.Licence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-mgr", name="getlicence", description="Returns licence string installed for productId")
public class GetProductLicenceCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(GetProductLicenceCommand.class);
    private LicenceService _licenceService;
    @Argument(index=0, name="productId", description="Product Id to which licence-mgr applies", required=true, multiValued=false)
    String productId = null;

    public LicenceService getLicenceService() {
        return this._licenceService;
    }

    public void setLicenceService(LicenceService licenceService) {
        this._licenceService = licenceService;
    }

    protected Object doExecute() throws Exception {
        try {
            String licence = this.getLicenceService().getLicence(this.productId);
            if (licence == null) {
                System.err.println("no licence installed for productId='" + this.productId + "'");
                LOG.error("no licence installed for productId='" + this.productId + "'");
            } else {
                String metadatastr = Licence.getUnverifiedMetadata(licence).toXml();
                String msg = "Found licence ProductId='" + this.productId + "'" + "\n              licence=  '" + licence + "'" + "\n              licenceMetadata='" + metadatastr + "'";
                LOG.error(msg);
                System.out.println(msg);
            }
        }
        catch (Exception e) {
            System.err.println("Error getting licence for productId. Exception=" + e);
            LOG.error("Error getting licence for productId. Exception=", (Throwable)e);
        }
        return null;
    }
}

