/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.util.Set;
import org.opennms.karaf.licencemgr.AesSymetricKeyCipher;
import org.opennms.karaf.licencemgr.LicenceAuthenticator;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.RsaAsymetricKeyCipher;
import org.opennms.karaf.licencemgr.StringCrc32Checksum;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenceAuthenticatorImpl
implements LicenceAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LicenceAuthenticatorImpl.class);
    private String productId;
    private String privateKeyEnryptedStr;
    private LicenceMetadata licenceMetadata = null;
    private String licencewithCRC = null;
    private LicenceService licenceService = null;

    public LicenceAuthenticatorImpl(String licencewithCRC, String productId, String privateKeyEnryptedStr) {
        if (licencewithCRC == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: licencewithCRC cannot be null");
        }
        if (productId == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: productId cannot be null");
        }
        if (privateKeyEnryptedStr == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: privateKeyEnryptedStr cannot be null");
        }
        this.licenceAuthenticatorImpl(licencewithCRC, productId, privateKeyEnryptedStr);
    }

    public LicenceAuthenticatorImpl(LicenceService licenceService, String productId, String privateKeyEnryptedStr) {
        if (licenceService == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: licenceService cannot be null");
        }
        if (productId == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: productId cannot be null");
        }
        if (privateKeyEnryptedStr == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: privateKeyEnryptedStr cannot be null");
        }
        this.productId = productId;
        this.privateKeyEnryptedStr = privateKeyEnryptedStr;
        this.licenceService = licenceService;
        this.licencewithCRC = licenceService.getLicence(productId);
        if (this.licencewithCRC == null) {
            LOG.error("No licence installed for productId:'" + productId + "'");
            throw new ServiceException("No licence installed for productId:'" + productId + "'");
        }
        String systemId = licenceService.getSystemId();
        if (systemId == null) {
            throw new ServiceException("systemId cannot be null");
        }
        try {
            this.licenceAuthenticatorImpl(this.licencewithCRC, productId, privateKeyEnryptedStr);
            Integer maxSizeSystemIds = 0;
            if (this.licenceMetadata.getMaxSizeSystemIds() == null || "".equals(this.licenceMetadata.getMaxSizeSystemIds())) {
                throw new ServiceException("the maxSizeSystemIds value must be set as integer for productId='" + productId + "'");
            }
            try {
                maxSizeSystemIds = Integer.parseInt(this.licenceMetadata.getMaxSizeSystemIds());
            }
            catch (Exception e) {
                throw new ServiceException("the maxSizeSystemIds '" + this.licenceMetadata.getMaxSizeSystemIds() + "' cannot be parsed as int in licence for productId='" + productId + "'", (Throwable)e);
            }
            Set<String> systemIds = this.licenceMetadata.getSystemIds();
            if (maxSizeSystemIds == null) {
                throw new ServiceException("maxSizeSystemIds must not be null in licence for productId='" + productId + "'");
            }
            if (systemIds.size() > maxSizeSystemIds) {
                throw new ServiceException("the systemIds list in licence for productId='" + productId + "' contains " + systemIds.size() + " entries which is more than maxSizeSystemIds (" + maxSizeSystemIds + ")");
            }
            if (maxSizeSystemIds != 0 && !systemIds.contains(systemId)) {
                throw new ServiceException("installed licence for productId='" + productId + "'" + "does not contain local systemId = '" + systemId + "'");
            }
            licenceService.addAuthenticatedProductId(productId);
            System.out.println("BundleLicenceAuthenticator authenticated licence for productId=" + productId);
            System.out.println("Licence Metadata xml=" + this.licenceMetadata.toXml());
            LOG.info("BundleLicenceAuthenticator authenticated licence for productId=" + productId);
            LOG.info("Licence Metadata xml=" + this.licenceMetadata.toXml());
        }
        catch (Exception e) {
            licenceService.removeAuthenticatedProductId(productId);
            throw e;
        }
    }

    private void licenceAuthenticatorImpl(String licencewithCRC, String productId, String privateKeyEnryptedStr) {
        if (licencewithCRC == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: licencewithCRC cannot be null");
        }
        if (productId == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: productId cannot be null");
        }
        if (privateKeyEnryptedStr == null) {
            throw new RuntimeException("LicenceAuthenticatoImpl: privateKeyEnryptedStr cannot be null");
        }
        StringCrc32Checksum stringCrc32Checksum = new StringCrc32Checksum();
        String licenceStr = stringCrc32Checksum.removeCRC(licencewithCRC);
        if (licenceStr == null) {
            LOG.error("licence checksum incorrect for productId:'" + productId + "'");
            throw new ServiceException("licence checksum incorrect for productId:'" + productId + "'");
        }
        String[] components = licenceStr.split(":");
        if (components.length != 3) {
            LOG.error("incorrectly formatted licence string for productId:'" + productId + "'");
            throw new ServiceException("incorrectly formatted licence string for productId:'" + productId + "'");
        }
        String receivedLicenceMetadataHexStr = components[0];
        String receivedEncryptedHashStr = components[1];
        String receivedAesSecretKeyStr = components[2];
        AesSymetricKeyCipher aesCipher = new AesSymetricKeyCipher();
        aesCipher.setEncodedSecretKeyStr(receivedAesSecretKeyStr);
        String decryptedPrivateKeyStr = aesCipher.aesDecryptStr(privateKeyEnryptedStr);
        RsaAsymetricKeyCipher rsaAsymetricKeyCipher = new RsaAsymetricKeyCipher();
        rsaAsymetricKeyCipher.setPrivateKeyStr(decryptedPrivateKeyStr);
        String decriptedHashStr = rsaAsymetricKeyCipher.rsaDecryptString(receivedEncryptedHashStr);
        this.licenceMetadata = new LicenceMetadata();
        this.licenceMetadata.fromHexString(receivedLicenceMetadataHexStr);
        String sha256Hash = this.licenceMetadata.sha256Hash();
        if (!sha256Hash.equals(decriptedHashStr)) {
            LOG.error("licence hash not verified  for productId:'" + productId + "'");
            throw new ServiceException("licence hash not verified  for productId:'" + productId + "'");
        }
        if (!productId.equals(this.licenceMetadata.getProductId())) {
            LOG.error("licence productId='" + this.licenceMetadata.getProductId() + "' does not match expected productId:'" + productId + "'");
            throw new ServiceException("licence productId='" + this.licenceMetadata.getProductId() + "' does not match expected productId:'" + productId + "'");
        }
    }

    public void destroyMethod() {
        if (this.licenceService != null && this.productId != null) {
            try {
                this.licenceService.removeAuthenticatedProductId(this.productId);
            }
            catch (Exception e) {
                System.err.println("BundleLicenceAuthenticator cannot remove authenticatedProductId=" + this.productId);
                LOG.error("BundleLicenceAuthenticator cannot remove authenticatedProductId=" + this.productId);
            }
        }
        System.out.println("BundleLicenceAuthenticator shutdown for productId=" + this.productId);
        LOG.info("BundleLicenceAuthenticator shutdown for productId=" + this.productId);
    }

    @Override
    public LicenceMetadata getLicenceMetadata() {
        return this.licenceMetadata;
    }

    @Override
    public String getLicencewithCRC() {
        return this.licencewithCRC;
    }
}

