/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.opennms.karaf.licencemgr.BundleLicenceSpec;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencepub.LicencePublisher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleLicenceSpecImpl
implements BundleLicenceSpec {
    private static final Logger LOG = LoggerFactory.getLogger(BundleLicenceSpecImpl.class);
    private BundleContext bundleContext;
    private LicenceMetadata licenceMetadataSpec = null;
    private LicencePublisher licencePublisher = null;
    private String productId = null;
    private String licenceMetadataUri = null;
    private String aesSecretKeyStr = null;
    private String publicKeyStr = null;

    private String readFile(InputStream is) throws IOException {
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public BundleLicenceSpecImpl() {
    }

    public BundleLicenceSpecImpl(LicencePublisher licencePublisher, BundleContext bundleContext, String productId, String licenceMetadataUri, String aesSecretKeyStr, String publicKeyStr) {
        if (licencePublisher == null) {
            throw new IllegalArgumentException("licencePublisher cannot be null");
        }
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        if (licenceMetadataUri == null) {
            throw new IllegalArgumentException("licenceMetadataUri cannot be null");
        }
        if (aesSecretKeyStr == null) {
            throw new IllegalArgumentException("aesSecretKeyStr cannot be null");
        }
        if (publicKeyStr == null) {
            throw new IllegalArgumentException("publicKeyStr cannot be null");
        }
        this.setLicencePublisher(licencePublisher);
        this.setBundleContext(bundleContext);
        this.setProductId(productId);
        this.setLicenceMetadataUri(licenceMetadataUri);
        this.setPublicKeyStr(publicKeyStr);
        this.setAesSecretKeyStr(aesSecretKeyStr);
        this.registerSpec();
    }

    @Override
    public void registerSpec() {
        if (this.licencePublisher == null) {
            throw new RuntimeException("licencePublisher cannot be null");
        }
        if (this.bundleContext == null) {
            throw new RuntimeException("bundleContext cannot be null");
        }
        if (this.licenceMetadataSpec == null) {
            if (this.licenceMetadataUri == null) {
                throw new IllegalArgumentException("licenceMetadataUri cannot be null if no licenceMetadataSpec defined");
            }
            InputStream is = null;
            try {
                Bundle bundle = this.bundleContext.getBundle();
                is = bundle.getEntry(this.licenceMetadataUri).openStream();
                String licenceMetadataXml = this.readFile(is);
                this.licenceMetadataSpec = new LicenceMetadata();
                this.licenceMetadataSpec.fromXml(licenceMetadataXml);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot load licenceMetadataSpec file from bundle licenceMetadataUri=" + this.licenceMetadataUri + "  " + e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                is = null;
            }
        }
        if (!this.productId.equals(this.licenceMetadataSpec.getProductId())) {
            throw new IllegalArgumentException("productId in licenceMetadataSpec =" + this.licenceMetadataSpec.getProductId() + " is different to productId for licence keys =" + this.productId + "  ");
        }
        LicenceSpecification licenceSpec = new LicenceSpecification(this.productId, this.licenceMetadataSpec, this.aesSecretKeyStr, this.publicKeyStr);
        this.licencePublisher.addLicenceSpec(licenceSpec);
        System.out.println("Registered Licence Specification for productId=" + this.licenceMetadataSpec.getProductId());
        LOG.info("Registered Licence Specification for productId=" + this.licenceMetadataSpec.getProductId());
    }

    @Override
    public void unregisterSpec() {
        if (this.licencePublisher != null) {
            try {
                this.licencePublisher.removeLicenceSpec(this.licenceMetadataSpec.getProductId());
                System.out.println("Unregistered Licence Specification for productId=" + this.licenceMetadataSpec.getProductId());
                LOG.info("Unregistered Licence Specification for productId=" + this.licenceMetadataSpec.getProductId());
            }
            catch (Exception e) {
                System.err.println("Problem Unregistering Licence Specification for productId=" + this.licenceMetadataSpec.getProductId() + "  " + e);
                LOG.error("Problem Unregistering Licence Specification for productId=" + this.licenceMetadataSpec.getProductId() + "  ", (Throwable)e);
            }
            finally {
                this.licencePublisher = null;
            }
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.bundleContext = bundleContext;
    }

    @Override
    public LicenceMetadata getLicenceMetadataSpec() {
        return this.licenceMetadataSpec;
    }

    @Override
    public void setLicenceMetadataSpec(LicenceMetadata licenceMetadataSpec) {
        if (licenceMetadataSpec == null) {
            throw new RuntimeException("licenceMetadataSpec cannot be null");
        }
        this.licenceMetadataSpec = licenceMetadataSpec;
    }

    @Override
    public LicencePublisher getLicencePublisher() {
        return this.licencePublisher;
    }

    @Override
    public void setLicencePublisher(LicencePublisher licencePublisher) {
        if (licencePublisher == null) {
            throw new RuntimeException("licencePublisher cannot be null");
        }
        this.licencePublisher = licencePublisher;
    }

    @Override
    public String getProductId() {
        return this.productId;
    }

    @Override
    public void setProductId(String productId) {
        this.productId = productId;
    }

    @Override
    public String getLicenceMetadataUri() {
        return this.licenceMetadataUri;
    }

    @Override
    public void setLicenceMetadataUri(String licenceMetadataUri) {
        if (licenceMetadataUri == null) {
            throw new RuntimeException("licenceMetadataUri cannot be null");
        }
        this.licenceMetadataUri = licenceMetadataUri;
    }

    @Override
    public String getAesSecretKeyStr() {
        return this.aesSecretKeyStr;
    }

    @Override
    public void setAesSecretKeyStr(String aesSecretKeyStr) {
        if (aesSecretKeyStr == null) {
            throw new RuntimeException("aesSecretKeyStr cannot be null");
        }
        this.aesSecretKeyStr = aesSecretKeyStr;
    }

    @Override
    public String getPublicKeyStr() {
        return this.publicKeyStr;
    }

    @Override
    public void setPublicKeyStr(String publicKeyStr) {
        if (publicKeyStr == null) {
            throw new RuntimeException("publicKeyStr cannot be null");
        }
        this.publicKeyStr = publicKeyStr;
    }
}

