/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.dbnotifier;

import com.impossibl.postgres.jdbc.PGDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbNotifierDataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DbNotifierDataSourceFactory.class);
    private static final String OPENNMS_DATASOURCE_CONFIG_FILE_NAME = "opennms-datasources.xml";
    private static final String OPENNMS_DATA_SOURCE_NAME = "opennms";
    private String userName = null;
    private String passWord = null;
    private String dataBaseName = null;
    private String hostname = null;
    private int port = 5432;
    private String dsfileUri = null;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    public void setDataBaseName(String dataBaseName) {
        this.dataBaseName = dataBaseName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return Integer.toString(this.port);
    }

    public void setPort(String port) {
        this.port = Integer.parseInt(port);
    }

    public String getDataSourceFileUri() {
        return this.dsfileUri;
    }

    public void setDataSourceFileUri(String fileUri) {
        this.dsfileUri = fileUri;
    }

    public PGDataSource getPGDataSource() {
        PGDataSource pgdc = new PGDataSource();
        pgdc.setHost(this.hostname);
        pgdc.setPort(this.port);
        pgdc.setDatabase(this.dataBaseName);
        pgdc.setUser(this.userName);
        pgdc.setPassword(this.passWord);
        return pgdc;
    }

    public void init() {
        if (this.dataBaseName != null) {
            LOG.debug("using values supplied in .cfg file for host: " + this.hostname + " port: " + this.port + " dataBaseName " + this.dataBaseName + " userName: " + this.userName + "  password :" + this.passWord);
        } else {
            try {
                DataSourceConfiguration dsconfig;
                InputStream istream = null;
                if (this.dsfileUri != null) {
                    File dsFile = new File(this.dsfileUri);
                    LOG.debug("loading database config from " + dsFile.getAbsolutePath());
                    istream = new FileInputStream(dsFile);
                }
                if (istream == null) {
                    LOG.debug("loading database config from classpath fileopennms-datasources.xml");
                    istream = this.getClass().getClassLoader().getResourceAsStream(OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
                    if (istream == null) {
                        throw new RuntimeException("could not load database config from classpath opennms-datasources.xml");
                    }
                }
                try (InputStreamReader reader = new InputStreamReader(istream);){
                    dsconfig = (DataSourceConfiguration)JaxbUtils.unmarshal(DataSourceConfiguration.class, (Reader)reader);
                }
                JdbcDataSource[] datasourceArray = dsconfig.getJdbcDataSource();
                String dataSourceName = null;
                JdbcDataSource ds = null;
                for (int index = 0; !OPENNMS_DATA_SOURCE_NAME.equals(dataSourceName) && index < datasourceArray.length; ++index) {
                    ds = datasourceArray[index];
                    dataSourceName = ds.getName();
                }
                if (!OPENNMS_DATA_SOURCE_NAME.equals(dataSourceName)) {
                    throw new RuntimeException("no datasource opennms found in opennms-datasources.xml");
                }
                this.userName = ds.getUserName();
                this.passWord = ds.getPassword();
                this.dataBaseName = ds.getDatabaseName();
                String urlStr = ds.getUrl();
                String baseUrl = urlStr.replace("jdbc:postgresql:", "http:");
                URL url = new URL(baseUrl);
                String protocol = url.getProtocol();
                this.hostname = url.getHost();
                this.port = url.getPort();
                LOG.debug("decoded urlStr:" + urlStr + " baseUrl:" + baseUrl + " protocol:" + protocol + " host:" + this.hostname + " port:" + this.port);
                LOG.debug("Using jdbc-data-source values supplied for opennms datasource in opennms-datasources.xml file for host: " + this.hostname + " port: " + this.port + " dataBaseName " + this.dataBaseName + " userName: " + this.userName + "  password :" + this.passWord);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot load database values from .cfg or opennms-datasources.xml", e);
            }
        }
    }
}

