/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.wmi.WmiAgentState;
import org.opennms.netmgt.collectd.wmi.WmiCollectionAttributeType;
import org.opennms.netmgt.collectd.wmi.WmiCollectionResource;
import org.opennms.netmgt.collectd.wmi.WmiCollectionSet;
import org.opennms.netmgt.collectd.wmi.WmiMultiInstanceCollectionResource;
import org.opennms.netmgt.collectd.wmi.WmiSingleInstanceCollectionResource;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.WmiDataCollectionConfigFactory;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.config.wmi.Attrib;
import org.opennms.netmgt.config.wmi.WmiCollection;
import org.opennms.netmgt.config.wmi.Wpm;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.protocols.wmi.WmiClient;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.opennms.protocols.wmi.wbem.OnmsWbemObject;
import org.opennms.protocols.wmi.wbem.OnmsWbemObjectSet;
import org.opennms.protocols.wmi.wbem.OnmsWbemProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WmiCollector
implements ServiceCollector {
    private final HashMap<Integer, WmiAgentState> m_scheduledNodes = new HashMap();
    private HashMap<String, AttributeGroupType> m_groupTypeList = new HashMap();
    private HashMap<String, WmiCollectionAttributeType> m_attribTypeList = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) {
        String collectionName = parameters.get("collection");
        if (collectionName == null) {
            collectionName = parameters.get("wmi-collection");
        }
        WmiCollection collection = WmiDataCollectionConfigFactory.getInstance().getWmiCollection(collectionName);
        WmiAgentState agentState = this.m_scheduledNodes.get(agent.getNodeId());
        this.loadAttributeGroupList(collection);
        this.loadAttributeTypeList(collection);
        WmiCollectionSet collectionSet = new WmiCollectionSet(agent);
        for (Wpm wpm : collection.getWpms().getWpm()) {
            if (agentState.shouldCheckAvailability(wpm.getName(), wpm.getRecheckInterval()) && !this.isGroupAvailable(agentState, wpm) || !agentState.groupIsAvailable(wpm.getName())) continue;
            WmiClient client = null;
            try {
                agentState.connect();
                client = (WmiClient)agentState.getWmiClient();
                OnmsWbemObjectSet wOS = client.performInstanceOf(wpm.getWmiClass());
                if (wOS == null) continue;
                for (int i = 0; i < wOS.count(); ++i) {
                    WmiCollectionResource resource = null;
                    OnmsWbemObject obj = wOS.get(i);
                    if (wOS.count() > 1) {
                        OnmsWbemProperty prop = obj.getWmiProperties().getByName(wpm.getKeyvalue());
                        Object propVal = prop.getWmiValue();
                        String instance = null;
                        instance = propVal instanceof String ? (String)propVal : propVal.toString();
                        resource = new WmiMultiInstanceCollectionResource(agent, instance, wpm.getResourceType());
                    } else {
                        resource = new WmiSingleInstanceCollectionResource(agent);
                    }
                    for (Attrib attrib : wpm.getAttrib()) {
                        OnmsWbemProperty prop = obj.getWmiProperties().getByName(attrib.getWmiObject());
                        WmiCollectionAttributeType attribType = this.m_attribTypeList.get(attrib.getName());
                        resource.setAttributeValue(attribType, prop.getWmiValue().toString());
                    }
                    collectionSet.getResources().add(resource);
                }
            }
            catch (WmiException e) {
                LogUtils.infof((Object)this, (Throwable)e, (String)"unable to collect params for wpm '%s'", (Object[])new Object[]{wpm.getName()});
            }
            finally {
                if (client != null) {
                    try {
                        client.disconnect();
                    }
                    catch (WmiException e) {
                        LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred disconnecting while collecting from WMI.", (Object[])new Object[0]);
                    }
                }
            }
        }
        collectionSet.setStatus(1);
        return collectionSet;
    }

    private void loadAttributeGroupList(WmiCollection collection) {
        for (Wpm wpm : collection.getWpms().getWpm()) {
            AttributeGroupType attribGroupType1 = new AttributeGroupType(wpm.getName(), wpm.getIfType());
            this.m_groupTypeList.put(wpm.getName(), attribGroupType1);
        }
    }

    private void loadAttributeTypeList(WmiCollection collection) {
        for (Wpm wpm : collection.getWpms().getWpm()) {
            for (Attrib attrib : wpm.getAttrib()) {
                AttributeGroupType attribGroupType = this.m_groupTypeList.get(wpm.getName());
                WmiCollectionAttributeType attribType = new WmiCollectionAttributeType(attrib, attribGroupType);
                this.m_attribTypeList.put(attrib.getName(), attribType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGroupAvailable(WmiAgentState agentState, Wpm wpm) {
        LogUtils.debugf((Object)this, (String)"Checking availability of group %s", (Object[])new Object[]{wpm.getName()});
        WmiManager manager = null;
        try {
            manager = agentState.getManager();
            manager.init();
            WmiParams params = new WmiParams("InstanceOf", "not-applicable", "NOOP", wpm.getWmiClass(), wpm.getKeyvalue());
            WmiResult result = manager.performOp(params);
            boolean isAvailable = result.getResultCode() == 0;
            agentState.setGroupIsAvailable(wpm.getName(), isAvailable);
            LogUtils.debugf((Object)this, (String)"Group %s is %s%s.", (Object[])new Object[]{wpm.getName(), isAvailable ? "" : "not ", "available"});
        }
        catch (WmiException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Error checking group (%s) availability.", (Object[])new Object[]{wpm.getName()});
            agentState.setGroupIsAvailable(wpm.getName(), false);
            boolean bl = false;
            return bl;
        }
        finally {
            if (manager != null) {
                try {
                    manager.close();
                }
                catch (WmiException e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred closing the WMI Manager", (Object[])new Object[0]);
                }
            }
        }
        return true;
    }

    public void initialize(Map parameters) {
        LogUtils.debugf((Object)this, (String)"initialize: Initializing WmiCollector.", (Object[])new Object[0]);
        this.m_scheduledNodes.clear();
        this.initWMIPeerFactory();
        this.initWMICollectionConfig();
        this.initDatabaseConnectionFactory();
        this.initializeRrdRepository();
    }

    private void initWMIPeerFactory() {
        LogUtils.debugf((Object)this, (String)"initialize: Initializing WmiPeerFactory", (Object[])new Object[0]);
        try {
            WmiPeerFactory.init();
        }
        catch (MarshalException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Error marshalling configuration.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Error validating configuration.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Error reading configuration.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initWMICollectionConfig() {
        LogUtils.debugf((Object)this, (String)"initialize: Initializing collector: %s", (Object[])new Object[]{this.getClass()});
        try {
            WmiDataCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Error marshalling configuration.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Error validating configuration.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Error locating configuration.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Error reading configuration.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initializeRrdRepository() {
        LogUtils.debugf((Object)this, (String)"initializeRrdRepository: Initializing RRD repo from WmiCollector...", (Object[])new Object[0]);
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        File f = new File(WmiDataCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + DataCollectionConfigFactory.getInstance().getRrdPath());
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initDatabaseConnectionFactory: Error initializing DataSourceFactory.", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
    }

    public void initialize(CollectionAgent agent, Map parameters) {
        LogUtils.debugf((Object)this, (String)"initialize: Initializing WMI collection for agent: %s", (Object[])new Object[]{agent});
        Integer scheduledNodeKey = new Integer(agent.getNodeId());
        WmiAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            LogUtils.infof((Object)this, (String)"initialize: Not scheduling interface for WMI collection: %s", (Object[])new Object[]{nodeState.getAddress()});
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(" for address: ");
            sb.append(nodeState.getAddress());
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            LogUtils.debugf((Object)this, (String)sb.toString(), (Object[])new Object[0]);
            throw new IllegalStateException(sb.toString());
        }
        nodeState = new WmiAgentState(agent.getInetAddress(), parameters);
        LogUtils.infof((Object)this, (String)"initialize: Scheduling interface for collection: %s", (Object[])new Object[]{nodeState.getAddress()});
        this.m_scheduledNodes.put(scheduledNodeKey, nodeState);
    }

    public void release() {
        this.m_scheduledNodes.clear();
    }

    public void release(CollectionAgent agent) {
        WmiAgentState nodeState = this.m_scheduledNodes.get(agent.getNodeId());
        if (nodeState != null) {
            this.m_scheduledNodes.remove(agent.getNodeId());
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return WmiDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }
}

