/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.wmi;

import java.io.File;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.wmi.WmiCollectionResource;
import org.opennms.netmgt.model.RrdRepository;

public class WmiMultiInstanceCollectionResource
extends WmiCollectionResource {
    private String m_inst;
    private String m_name;

    public WmiMultiInstanceCollectionResource(CollectionAgent agent, String instance, String name) {
        super(agent);
        this.m_inst = instance;
        this.m_name = name;
    }

    private Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, String.valueOf(this.m_agent.getNodeId()));
        File typeDir = new File(nodeDir, this.m_name);
        File instDir = new File(typeDir, this.m_inst.replaceAll("\\s+", "_").replaceAll(":", "_").replaceAll("\\\\", "_").replaceAll("[\\[\\]]", "_"));
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getResourceDir: " + instDir.toString()));
        }
        return instDir;
    }

    public String getResourceTypeName() {
        return this.m_name;
    }

    public String getInstance() {
        return this.m_inst;
    }

    public String toString() {
        return "Node[" + this.m_agent.getNodeId() + "]/type[" + this.m_name + "]/instance[" + this.m_inst + "]";
    }
}

