/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.wmi;

import java.io.File;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.wmi.WmiCollectionResource;
import org.opennms.netmgt.model.RrdRepository;

public class WmiMultiInstanceCollectionResource
extends WmiCollectionResource {
    private String m_inst;
    private String m_name;

    public WmiMultiInstanceCollectionResource(CollectionAgent agent, String instance, String name) {
        super(agent);
        this.m_inst = instance;
        this.m_name = name;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, this.getParent());
        File typeDir = new File(nodeDir, this.m_name);
        File instDir = new File(typeDir, this.m_inst.replaceAll("\\s+", "_").replaceAll(":", "_").replaceAll("\\\\", "_").replaceAll("[\\[\\]]", "_"));
        LogUtils.debugf((Object)((Object)this), (String)"getResourceDir: %s", (Object[])new Object[]{instDir});
        return instDir;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_name;
    }

    @Override
    public String getInstance() {
        return this.m_inst;
    }

    public String toString() {
        return "Node[" + this.m_agent.getNodeId() + "]/type[" + this.m_name + "]/instance[" + this.m_inst + "]";
    }
}

