/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.wmi;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.provision.support.AbstractDetector;
import org.opennms.protocols.wmi.WmiAgentConfig;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class WmiDetector
extends AbstractDetector {
    private static final String PROTOCOL_NAME = "WMI";
    private static final String DEFAULT_WMI_CLASS = "Win32_ComputerSystem";
    private static final String DEFAULT_WMI_OBJECT = "Status";
    private static final String DEFAULT_WMI_COMP_VAL = "OK";
    private static final String DEFAULT_WMI_MATCH_TYPE = "all";
    private static final String DEFAULT_WMI_COMP_OP = "EQ";
    private static final String DEFAULT_WMI_WQL = "NOTSET";
    private String m_matchType;
    private String m_compVal;
    private String m_compOp;
    private String m_wmiClass;
    private String m_wmiObject;
    private String m_wmiWqlStr;
    private String m_username;
    private String m_password;
    private String m_domain;

    public WmiDetector() {
        super(PROTOCOL_NAME, 0);
    }

    protected void onInit() {
        this.setMatchType(this.getMatchType() != null ? this.getMatchType() : DEFAULT_WMI_MATCH_TYPE);
        this.setCompVal(this.getCompVal() != null ? this.getCompVal() : DEFAULT_WMI_COMP_VAL);
        this.setCompOp(this.getCompOp() != null ? this.getCompOp() : DEFAULT_WMI_COMP_OP);
        this.setWmiClass(this.getWmiClass() != null ? this.getWmiClass() : DEFAULT_WMI_CLASS);
        this.setWmiObject(this.getWmiObject() != null ? this.getWmiObject() : DEFAULT_WMI_OBJECT);
        this.setWmiWqlStr(this.getWmiWqlStr() != null ? this.getWmiWqlStr() : DEFAULT_WMI_WQL);
    }

    public boolean isServiceDetected(InetAddress address) {
        WmiResult result;
        WmiParams clientParams = null;
        clientParams = this.getWmiWqlStr().equals(DEFAULT_WMI_WQL) ? new WmiParams("InstanceOf", this.getCompVal(), this.getCompOp(), this.getWmiClass(), this.getWmiObject()) : new WmiParams("Wql", this.getCompVal(), this.getCompOp(), this.getWmiWqlStr(), this.getWmiObject());
        WmiAgentConfig agentConfig = WmiPeerFactory.getInstance().getAgentConfig(address);
        if (this.getUsername() != null) {
            agentConfig.setUsername(this.getUsername());
        }
        if (this.getPassword() != null) {
            agentConfig.setPassword(this.getPassword());
        }
        if (this.getDomain() != null) {
            agentConfig.setDomain(this.getDomain());
        }
        if (this.getRetries() > 0) {
            agentConfig.setRetries(this.getRetries());
        }
        if (this.getTimeout() > 0) {
            agentConfig.setTimeout(this.getTimeout());
        }
        return (result = this.isServer(address, agentConfig.getUsername(), agentConfig.getPassword(), agentConfig.getDomain(), this.getMatchType(), agentConfig.getRetries(), agentConfig.getTimeout(), clientParams)) != null && result.getResultCode() != 1 && result.getResultCode() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WmiResult isServer(InetAddress host, String user, String pass, String domain, String matchType, int retries, int timeout, WmiParams params) {
        boolean isAServer = false;
        WmiResult result = null;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            WmiManager mgr = null;
            try {
                mgr = new WmiManager(InetAddressUtils.str((InetAddress)host), user, pass, domain, matchType);
                mgr.init();
                result = mgr.performOp(params);
                if (params.getWmiOperation().equals("Wql")) {
                    this.log().debug("WmiPlugin: " + params.getWql() + " : " + WmiResult.convertStateToString(result.getResultCode()));
                } else {
                    this.log().debug("WmiPlugin: \\\\" + params.getWmiClass() + "\\" + params.getWmiObject() + " : " + WmiResult.convertStateToString(result.getResultCode()));
                }
                isAServer = true;
                continue;
            }
            catch (WmiException e) {
                StringBuffer message = new StringBuffer();
                message.append("WmiPlugin: Check failed... : ");
                message.append(e.getMessage());
                message.append(" : ");
                message.append(e.getCause() == null ? "" : e.getCause().getMessage());
                this.log().info(message.toString());
                isAServer = false;
                continue;
            }
            finally {
                if (mgr != null) {
                    try {
                        mgr.close();
                    }
                    catch (WmiException e) {
                        this.log().warn("an error occurred closing the WMI Manager", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public void dispose() {
    }

    public void setMatchType(String matchType) {
        this.m_matchType = matchType;
    }

    public String getMatchType() {
        return this.m_matchType;
    }

    public void setCompVal(String compVal) {
        this.m_compVal = compVal;
    }

    public String getCompVal() {
        return this.m_compVal;
    }

    public void setCompOp(String compOp) {
        this.m_compOp = compOp;
    }

    public String getCompOp() {
        return this.m_compOp;
    }

    public void setWmiClass(String wmiClass) {
        this.m_wmiClass = wmiClass;
    }

    public String getWmiClass() {
        return this.m_wmiClass;
    }

    public void setWmiObject(String wmiObject) {
        this.m_wmiObject = wmiObject;
    }

    public String getWmiObject() {
        return this.m_wmiObject;
    }

    public void setWmiWqlStr(String wmiWqlStr) {
        this.m_wmiWqlStr = wmiWqlStr;
    }

    public String getWmiWqlStr() {
        return this.m_wmiWqlStr;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public String getDomain() {
        return this.m_domain;
    }
}

