/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import org.opennms.netmgt.model.discovery.IPAddrRange;
import org.opennms.netmgt.model.discovery.IPPollAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPPollRange
implements Iterable<IPPollAddress> {
    private IPAddrRange m_range;
    private long m_timeout;
    private int m_retries;

    public IPPollRange(String fromIP, String toIP, long timeout, int retries) throws UnknownHostException {
        this.m_range = new IPAddrRange(fromIP, toIP);
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    IPPollRange(InetAddress start, InetAddress end, long timeout, int retries) {
        this.m_range = new IPAddrRange(start, end);
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    IPPollRange(IPAddrRange range, long timeout, int retries) {
        this.m_range = range;
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public IPAddrRange getAddressRange() {
        return this.m_range;
    }

    public Enumeration<IPPollAddress> elements() {
        return new IPPollRangeGenerator(this.m_range.elements());
    }

    @Override
    public Iterator<IPPollAddress> iterator() {
        return new IPPollRangeGenerator(this.m_range.elements());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class IPPollRangeGenerator
    implements Enumeration<IPPollAddress>,
    Iterator<IPPollAddress> {
        private Enumeration<InetAddress> m_range;

        public IPPollRangeGenerator(Enumeration<InetAddress> en) {
            this.m_range = en;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_range.hasMoreElements();
        }

        @Override
        public IPPollAddress nextElement() {
            return new IPPollAddress(this.m_range.nextElement(), IPPollRange.this.m_timeout, IPPollRange.this.m_retries);
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public IPPollAddress next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove operation not supported");
        }
    }
}

