/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;

public class RadiusClient {
    private static byte[] NAS_ID;
    private static byte[] NAS_IP;
    private static final int AUTH_LOOP_COUNT = 3;
    private static final int ACCT_LOOP_COUNT = 3;
    private static final int DEFAULT_AUTH_PORT = 1812;
    private static final int DEFAULT_ACCT_PORT = 1813;
    private static final int DEFAULT_SOCKET_TIMEOUT = 6000;
    private String sharedSecret = "";
    private InetAddress hostname = null;
    private int authenticationPort = 1812;
    private int accountingPort = 1813;
    private DatagramSocket socket = null;
    private int socketTimeout = 6000;
    private MessageDigest md5MessageDigest;

    public RadiusClient(String string, String string2) throws RadiusException, InvalidParameterException {
        this(string, 1812, 1813, string2, 6000);
    }

    public RadiusClient(String string, int n, int n2, String string2) throws RadiusException, InvalidParameterException {
        this(string, n, n2, string2, 6000);
    }

    public RadiusClient(String string, int n, int n2, String string2, int n3) throws RadiusException, InvalidParameterException {
        this.setHostname(string);
        this.setSharedSecret(string2);
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            throw new RadiusException(socketException.getMessage());
        }
        this.setTimeout(n3);
        try {
            this.md5MessageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RadiusException(noSuchAlgorithmException.getMessage());
        }
        this.setAuthPort(n);
        this.setAcctPort(n2);
    }

    public RadiusPacket authenticate(RadiusPacket radiusPacket) throws RadiusException, InvalidParameterException {
        return this.authenticate(radiusPacket, 3);
    }

    public RadiusPacket authenticate(RadiusPacket radiusPacket, int n) throws RadiusException, InvalidParameterException {
        byte[] byArray;
        byte by;
        if (null == radiusPacket) {
            throw new InvalidParameterException("accessRequest parameter cannot be null");
        }
        if (n < 0) {
            throw new InvalidParameterException("retries must be zero or greater!");
        }
        if (n == 0) {
            n = 3;
        }
        if ((by = radiusPacket.getPacketType()) != 1) {
            throw new InvalidParameterException("Invalid packet type submitted to authenticate");
        }
        byte by2 = radiusPacket.getPacketIdentifier();
        byte[] byArray2 = this.makeRFC2865RequestAuthenticator();
        try {
            byArray = radiusPacket.getAttribute(2).getValue();
            if (byArray.length > 0) {
                byte[] byArray3 = this.encodePapPassword(byArray, byArray2);
                radiusPacket.setAttribute(new RadiusAttribute(2, byArray3));
            }
        }
        catch (RadiusException radiusException) {
            // empty catch block
        }
        radiusPacket.setAttribute(new RadiusAttribute(32, NAS_ID));
        byArray = radiusPacket.getAttributeBytes();
        short s = (short)(20 + byArray.length);
        DatagramPacket datagramPacket = this.composeRadiusPacket(this.getAuthPort(), by, by2, s, byArray2, byArray);
        RadiusPacket radiusPacket2 = null;
        datagramPacket = this.sendReceivePacket(datagramPacket, n);
        if (datagramPacket == null) {
            throw new RadiusException("null returned from sendReceivePacket");
        }
        radiusPacket2 = this.checkRadiusPacket(datagramPacket, by2, byArray2);
        return radiusPacket2;
    }

    public RadiusPacket account(RadiusPacket radiusPacket) throws InvalidParameterException, RadiusException {
        if (null == radiusPacket) {
            throw new InvalidParameterException("requestPacket parameter cannot be null");
        }
        byte by = radiusPacket.getPacketType();
        if (by != 4) {
            throw new InvalidParameterException("Invalid type passed in for RadiusPacket");
        }
        try {
            radiusPacket.getAttribute(1);
            radiusPacket.getAttribute(40);
            radiusPacket.getAttribute(44);
            radiusPacket.getAttribute(6);
        }
        catch (RadiusException radiusException) {
            throw new InvalidParameterException("Missing RadiusAttribute in Accounting RequestPacket: " + radiusException.getMessage());
        }
        byte by2 = radiusPacket.getPacketIdentifier();
        radiusPacket.setAttribute(new RadiusAttribute(32, NAS_ID));
        byte[] byArray = radiusPacket.getAttributeBytes();
        short s = (short)(20 + byArray.length);
        byte[] byArray2 = this.makeRFC2866RequestAuthenticator(by, by2, s, byArray);
        DatagramPacket datagramPacket = this.composeRadiusPacket(this.getAcctPort(), by, by2, s, byArray2, byArray);
        RadiusPacket radiusPacket2 = null;
        datagramPacket = this.sendReceivePacket(datagramPacket, 3);
        if (datagramPacket != null) {
            radiusPacket2 = this.checkRadiusPacket(datagramPacket, by2, byArray2);
            if (5 != radiusPacket2.getPacketType()) {
                throw new RadiusException("The radius Server responded with an incorrect response type.");
            }
        } else {
            throw new RadiusException("null returned from sendReceivePacket");
        }
        return radiusPacket2;
    }

    private byte[] encodePapPassword(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        if (byArray.length > 128) {
            byArray3 = new byte[128];
            System.arraycopy(byArray, 0, byArray3, 0, 128);
        } else {
            byArray3 = byArray;
        }
        byte[] byArray4 = null;
        byArray4 = byArray3.length < 128 ? (byArray3.length % 16 == 0 ? new byte[byArray3.length] : new byte[byArray3.length / 16 * 16 + 16]) : new byte[128];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        int n = byArray3.length;
        while (n < byArray4.length) {
            byArray4[n] = 0;
            ++n;
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        this.md5MessageDigest.update(byArray2);
        byte[] byArray5 = this.md5MessageDigest.digest();
        int n2 = 0;
        while (n2 < 16) {
            byArray4[n2] = (byte)(byArray5[n2] ^ byArray4[n2]);
            ++n2;
        }
        if (byArray4.length > 16) {
            int n3 = 16;
            while (n3 < byArray4.length) {
                this.md5MessageDigest.reset();
                this.md5MessageDigest.update(this.sharedSecret.getBytes());
                this.md5MessageDigest.update(byArray4, n3 - 16, 16);
                byArray5 = this.md5MessageDigest.digest();
                int n4 = 0;
                while (n4 < 16) {
                    byArray4[n3 + n4] = (byte)(byArray5[n4] ^ byArray4[n3 + n4]);
                    ++n4;
                }
                n3 += 16;
            }
        }
        return byArray4;
    }

    private byte[] makeRFC2865RequestAuthenticator() {
        byte[] byArray = new byte[16];
        Random random = new Random();
        int n = 0;
        while (n < 16) {
            byArray[n] = (byte)random.nextInt();
            ++n;
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        this.md5MessageDigest.update(byArray);
        return this.md5MessageDigest.digest();
    }

    private byte[] makeRFC2865ResponseAuthenticator(byte by, byte by2, short s, byte[] byArray, byte[] byArray2) {
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(by);
        this.md5MessageDigest.update(by2);
        this.md5MessageDigest.update((byte)(s >> 8));
        this.md5MessageDigest.update((byte)(s & 0xFF));
        this.md5MessageDigest.update(byArray, 0, byArray.length);
        this.md5MessageDigest.update(byArray2, 0, byArray2.length);
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        return this.md5MessageDigest.digest();
    }

    private byte[] makeRFC2866RequestAuthenticator(byte by, byte by2, short s, byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 16) {
            byArray2[n] = 0;
            ++n;
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(by);
        this.md5MessageDigest.update(by2);
        this.md5MessageDigest.update((byte)(s >> 8));
        this.md5MessageDigest.update((byte)(s & 0xFF));
        this.md5MessageDigest.update(byArray2, 0, byArray2.length);
        this.md5MessageDigest.update(byArray, 0, byArray.length);
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        return this.md5MessageDigest.digest();
    }

    public String getHostname() {
        return this.hostname.getHostName();
    }

    private void setHostname(String string) throws InvalidParameterException {
        if (string == null) {
            throw new InvalidParameterException("Hostname can not be null!");
        }
        if (string.trim().equals("")) {
            throw new InvalidParameterException("Hostname can not be empty or all blanks!");
        }
        try {
            this.hostname = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidParameterException("Hostname failed InetAddress.getByName() validation!");
        }
    }

    public int getAuthPort() {
        return this.authenticationPort;
    }

    private void setAuthPort(int n) throws InvalidParameterException {
        if (n <= 0 || n >= 65536) {
            throw new InvalidParameterException("Port value out of range!");
        }
        this.authenticationPort = n;
    }

    public int getAcctPort() {
        return this.accountingPort;
    }

    private void setAcctPort(int n) throws InvalidParameterException {
        if (n <= 0 || n >= 65536) {
            throw new InvalidParameterException("Port value out of range!");
        }
        this.accountingPort = n;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    private void setSharedSecret(String string) throws InvalidParameterException {
        if (string == null) {
            throw new InvalidParameterException("Shared secret can not be null!");
        }
        if (string.equals("")) {
            throw new InvalidParameterException("Shared secret can not be an empty string!");
        }
        this.sharedSecret = string;
    }

    public int getTimeout() {
        return this.socketTimeout;
    }

    private void setTimeout(int n) throws InvalidParameterException {
        if (n < 0) {
            throw new InvalidParameterException("A negative timeout value is not allowed!");
        }
        this.socketTimeout = n;
        try {
            if (null == this.socket) {
                this.socket = new DatagramSocket();
            }
            this.socket.setSoTimeout(this.socketTimeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RadiusPacket checkRadiusPacket(DatagramPacket datagramPacket, byte by, byte[] byArray) throws RadiusException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            try {
                int n = -1;
                int n2 = datagramPacket.getLength();
                byte by2 = dataInputStream.readByte();
                n = by2 & 0xFF;
                byte by3 = dataInputStream.readByte();
                if (by3 != by) {
                    throw new RadiusException("The RADIUS Server returned the wrong Identifier.");
                }
                short s = (short)(dataInputStream.readShort() & 0xFFFF);
                byte[] byArray2 = new byte[16];
                dataInputStream.readFully(byArray2);
                byte[] byArray3 = new byte[s - 20];
                dataInputStream.readFully(byArray3);
                byte[] byArray4 = this.makeRFC2865ResponseAuthenticator(by2, by3, s, byArray, byArray3);
                if (byArray2.length != 16) throw new RadiusException("Authenticator length is incorrect.");
                if (byArray4.length != 16) {
                    throw new RadiusException("Authenticator length is incorrect.");
                }
                int n3 = 0;
                while (n3 < byArray2.length) {
                    if (byArray2[n3] != byArray4[n3]) {
                        throw new RadiusException("Authenticators do not match, response packet not validated!");
                    }
                    ++n3;
                }
                RadiusPacket radiusPacket = new RadiusPacket(n, by3);
                int n4 = byArray3.length;
                if (n4 > 0) {
                    DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray3));
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = dataInputStream2.readByte() & 0xFF;
                        int n7 = dataInputStream2.readByte() & 0xFF;
                        byte[] byArray5 = new byte[n7 - 2];
                        dataInputStream2.read(byArray5, 0, n7 - 2);
                        radiusPacket.setAttribute(new RadiusAttribute(n6, byArray5));
                        n5 += n7;
                    }
                    dataInputStream2.close();
                }
                RadiusPacket radiusPacket2 = radiusPacket;
                Object var22_25 = null;
                try {
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    return radiusPacket2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return radiusPacket2;
            }
            catch (IOException iOException) {
                throw new RadiusException(iOException.getMessage());
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new RadiusException("Invalid response attributes sent back from server.");
            }
        }
        catch (Throwable throwable) {
            Object var22_26 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            dataInputStream.close();
            byteArrayInputStream.close();
            throw throwable;
        }
    }

    private DatagramPacket composeRadiusPacket(int n, byte by, byte by2, short s, byte[] byArray, byte[] byArray2) throws RadiusException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        DatagramPacket datagramPacket = null;
        try {
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(by2);
            dataOutputStream.writeShort(s);
            dataOutputStream.write(byArray, 0, 16);
            dataOutputStream.write(byArray2, 0, byArray2.length);
            datagramPacket = new DatagramPacket(new byte[s], s);
            datagramPacket.setPort(n);
            datagramPacket.setAddress(this.hostname);
            datagramPacket.setLength(s);
            datagramPacket.setData(byteArrayOutputStream.toByteArray());
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RadiusException(iOException.getMessage());
        }
        return datagramPacket;
    }

    private DatagramPacket sendReceivePacket(DatagramPacket datagramPacket, int n) throws RadiusException {
        if (datagramPacket.getLength() > 4096) {
            throw new RadiusException("Packet too big!");
        }
        if (datagramPacket.getLength() < 20) {
            throw new RadiusException("Packet too short !");
        }
        DatagramPacket datagramPacket2 = new DatagramPacket(new byte[4096], 4096);
        int n2 = 1;
        while (n2 <= n) {
            try {
                this.socket.send(datagramPacket);
                this.socket.receive(datagramPacket2);
                return datagramPacket2;
            }
            catch (IOException iOException) {
                if (n2 == n) {
                    throw new RadiusException(iOException.getMessage());
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RadiusClient: HostName = ");
        stringBuffer.append(this.getHostname());
        stringBuffer.append(" Port = ");
        stringBuffer.append(Integer.toString(this.getAuthPort()));
        stringBuffer.append(" Shared Secret = ");
        stringBuffer.append(this.getSharedSecret());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof RadiusClient)) {
            return false;
        }
        RadiusClient radiusClient = (RadiusClient)object;
        if (this.getHostname().equals(radiusClient.getHostname()) && this.getAuthPort() == radiusClient.getAuthPort() && this.getSharedSecret().equals(radiusClient.getSharedSecret())) {
            return true;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer(this.getHostname());
        stringBuffer.append(Integer.toString(this.getAuthPort()));
        stringBuffer.append(this.getSharedSecret());
        return stringBuffer.toString().hashCode();
    }

    protected void closeSocket() {
        this.socket.close();
    }

    public void finalize() throws Throwable {
        this.closeSocket();
        super.finalize();
    }

    static {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            NAS_ID = inetAddress.getHostName().getBytes();
            NAS_IP = inetAddress.getHostAddress().getBytes();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException.getMessage());
        }
    }
}

