/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.MBeanServerNotFoundException;

public class WebSphereMBeanServerFactoryBean
implements FactoryBean,
InitializingBean {
    private static final String ADMIN_SERVICE_FACTORY_CLASS = "com.ibm.websphere.management.AdminServiceFactory";
    private static final String GET_MBEAN_FACTORY_METHOD = "getMBeanFactory";
    private static final String GET_MBEAN_SERVER_METHOD = "getMBeanServer";
    private MBeanServer mbeanServer;
    static /* synthetic */ Class class$javax$management$MBeanServer;

    public void afterPropertiesSet() throws MBeanServerNotFoundException {
        try {
            Class<?> adminServiceClass = this.getClass().getClassLoader().loadClass(ADMIN_SERVICE_FACTORY_CLASS);
            Method getMBeanFactoryMethod = adminServiceClass.getMethod(GET_MBEAN_FACTORY_METHOD, new Class[0]);
            Object mbeanFactory = getMBeanFactoryMethod.invoke(null, new Object[0]);
            Method getMBeanServerMethod = mbeanFactory.getClass().getMethod(GET_MBEAN_SERVER_METHOD, new Class[0]);
            this.mbeanServer = (MBeanServer)getMBeanServerMethod.invoke(mbeanFactory, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            throw new MBeanServerNotFoundException("Could not find WebSphere's AdminServiceFactory class", ex);
        }
        catch (InvocationTargetException ex) {
            throw new MBeanServerNotFoundException("WebSphere's AdminServiceFactory.getMBeanFactory/getMBeanServer method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new MBeanServerNotFoundException("Could not access WebSphere's AdminServiceFactory.getMBeanFactory/getMBeanServer method", ex);
        }
    }

    public Object getObject() {
        return this.mbeanServer;
    }

    public Class getObjectType() {
        return this.mbeanServer != null ? this.mbeanServer.getClass() : (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = WebSphereMBeanServerFactoryBean.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer);
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

