/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.metadata;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedAttribute;
import org.springframework.jmx.export.metadata.ManagedNotification;
import org.springframework.jmx.export.metadata.ManagedOperation;
import org.springframework.jmx.export.metadata.ManagedOperationParameter;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.metadata.Attributes;
import org.springframework.util.Assert;

public class AttributesJmxAttributeSource
implements JmxAttributeSource,
InitializingBean {
    private Attributes attributes;
    static /* synthetic */ Class class$org$springframework$jmx$export$metadata$ManagedResource;
    static /* synthetic */ Class class$org$springframework$jmx$export$metadata$ManagedAttribute;
    static /* synthetic */ Class class$org$springframework$jmx$export$metadata$ManagedOperation;
    static /* synthetic */ Class class$org$springframework$jmx$export$metadata$ManagedOperationParameter;
    static /* synthetic */ Class class$org$springframework$jmx$export$metadata$ManagedNotification;

    public AttributesJmxAttributeSource() {
    }

    public AttributesJmxAttributeSource(Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes is required");
        }
        this.attributes = attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void afterPropertiesSet() {
        if (this.attributes == null) {
            throw new IllegalArgumentException("'attributes' is required");
        }
    }

    public ManagedResource getManagedResource(Class clazz) {
        Assert.notNull(this.attributes, "'attributes' is required");
        Collection attrs = this.attributes.getAttributes(clazz, class$org$springframework$jmx$export$metadata$ManagedResource == null ? (class$org$springframework$jmx$export$metadata$ManagedResource = AttributesJmxAttributeSource.class$("org.springframework.jmx.export.metadata.ManagedResource")) : class$org$springframework$jmx$export$metadata$ManagedResource);
        if (attrs.isEmpty()) {
            return null;
        }
        if (attrs.size() == 1) {
            return (ManagedResource)attrs.iterator().next();
        }
        throw new InvalidMetadataException("A Class can have only one ManagedResource attribute");
    }

    public ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        Assert.notNull(this.attributes, "'attributes' is required");
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd == null) {
            throw new InvalidMetadataException("The ManagedAttribute attribute is only valid for JavaBean properties: use ManagedOperation for methods");
        }
        Collection attrs = this.attributes.getAttributes(method, class$org$springframework$jmx$export$metadata$ManagedAttribute == null ? (class$org$springframework$jmx$export$metadata$ManagedAttribute = AttributesJmxAttributeSource.class$("org.springframework.jmx.export.metadata.ManagedAttribute")) : class$org$springframework$jmx$export$metadata$ManagedAttribute);
        if (attrs.isEmpty()) {
            return null;
        }
        if (attrs.size() == 1) {
            return (ManagedAttribute)attrs.iterator().next();
        }
        throw new InvalidMetadataException("A Method can have only one ManagedAttribute attribute");
    }

    public ManagedOperation getManagedOperation(Method method) {
        Assert.notNull(this.attributes, "'attributes' is required");
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null) {
            throw new InvalidMetadataException("The ManagedOperation attribute is not valid for JavaBean properties: use ManagedAttribute instead");
        }
        Collection attrs = this.attributes.getAttributes(method, class$org$springframework$jmx$export$metadata$ManagedOperation == null ? (class$org$springframework$jmx$export$metadata$ManagedOperation = AttributesJmxAttributeSource.class$("org.springframework.jmx.export.metadata.ManagedOperation")) : class$org$springframework$jmx$export$metadata$ManagedOperation);
        if (attrs.isEmpty()) {
            return null;
        }
        if (attrs.size() == 1) {
            return (ManagedOperation)attrs.iterator().next();
        }
        throw new InvalidMetadataException("A Method can have only one ManagedAttribute attribute");
    }

    public ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        Assert.notNull(this.attributes, "'attributes' is required");
        Collection attrs = this.attributes.getAttributes(method, class$org$springframework$jmx$export$metadata$ManagedOperationParameter == null ? (class$org$springframework$jmx$export$metadata$ManagedOperationParameter = AttributesJmxAttributeSource.class$("org.springframework.jmx.export.metadata.ManagedOperationParameter")) : class$org$springframework$jmx$export$metadata$ManagedOperationParameter);
        if (attrs.size() == 0) {
            return new ManagedOperationParameter[0];
        }
        if (attrs.size() != method.getParameterTypes().length) {
            throw new InvalidMetadataException("Method [" + method + "] has an incorrect number of ManagedOperationParameters specified");
        }
        ManagedOperationParameter[] params = new ManagedOperationParameter[attrs.size()];
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            ManagedOperationParameter param = (ManagedOperationParameter)it.next();
            if (param.getIndex() < 0 || param.getIndex() >= params.length) {
                throw new InvalidMetadataException("ManagedOperationParameter index for [" + param.getName() + "] is out of bounds");
            }
            params[param.getIndex()] = param;
        }
        return params;
    }

    public ManagedNotification[] getManagedNotifications(Class clazz) {
        Assert.notNull(this.attributes, "'attributes' is required");
        Collection attrs = this.attributes.getAttributes(clazz, class$org$springframework$jmx$export$metadata$ManagedNotification == null ? (class$org$springframework$jmx$export$metadata$ManagedNotification = AttributesJmxAttributeSource.class$("org.springframework.jmx.export.metadata.ManagedNotification")) : class$org$springframework$jmx$export$metadata$ManagedNotification);
        return attrs.isEmpty() ? new ManagedNotification[]{} : attrs.toArray(new ManagedNotification[attrs.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

