/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.IPHeader;

public class ErrorMessage
extends ICMPHeader {
    private IPHeader m_iphdr;
    private byte[] m_protoData;

    protected ErrorMessage(byte by, byte by2) {
        super(by, by2);
        this.m_iphdr = null;
        this.m_protoData = null;
    }

    public ErrorMessage(byte[] byArray, int n) {
        this.loadFromBuffer(byArray, n);
    }

    public final int loadFromBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 36) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP error message");
        }
        n = super.loadFromBuffer(byArray, n);
        this.m_iphdr = new IPHeader(byArray, n);
        if (byArray.length < n + 16 + this.m_iphdr.getHeaderLength()) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP error message");
        }
        n += this.m_iphdr.getHeaderLength();
        this.m_protoData = new byte[8];
        for (int i = 0; i < 8; ++i) {
            this.m_protoData[i] = byArray[n++];
        }
        return n;
    }

    public final IPHeader getIPHeader() {
        return this.m_iphdr;
    }

    protected void setIPHeader(IPHeader iPHeader) {
        this.m_iphdr = iPHeader;
    }

    public final byte[] getProtocolData() {
        return this.m_protoData;
    }

    protected void setProtocolData(byte[] byArray) {
        if (byArray.length < 8) {
            throw new IndexOutOfBoundsException("Protocol data must be 8 bytes in length");
        }
        if (byArray.length > 8) {
            throw new IllegalArgumentException("Protocol data cannot be more than 8 bytes in length");
        }
        this.m_protoData = byArray;
    }
}

