/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.model.AttributeStatisticVisitor;
import org.opennms.netmgt.model.AttributeVisitor;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RrdStatisticAttributeVisitor
implements AttributeVisitor,
InitializingBean {
    private RrdDao m_rrdDao;
    private String m_consolidationFunction;
    private Long m_startTime;
    private Long m_endTime;
    private AttributeStatisticVisitor m_statisticVisitor;

    public void visit(OnmsAttribute attribute) {
        if (!RrdGraphAttribute.class.isAssignableFrom(attribute.getClass())) {
            return;
        }
        double statistic = this.m_rrdDao.getPrintValue(attribute, this.m_consolidationFunction, this.m_startTime, this.m_endTime);
        if (Double.isNaN(statistic)) {
            return;
        }
        this.m_statisticVisitor.visit(attribute, statistic);
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"property rrdDao must be set to a non-null value");
        Assert.state((this.m_consolidationFunction != null ? 1 : 0) != 0, (String)"property consolidationFunction must be set to a non-null value");
        Assert.state((this.m_startTime != null ? 1 : 0) != 0, (String)"property startTime must be set to a non-null value");
        Assert.state((this.m_endTime != null ? 1 : 0) != 0, (String)"property endTime must be set to a non-null value");
        Assert.state((this.m_statisticVisitor != null ? 1 : 0) != 0, (String)"property statisticVisitor must be set to a non-null value");
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }

    public AttributeStatisticVisitor getStatisticVisitor() {
        return this.m_statisticVisitor;
    }

    public void setStatisticVisitor(AttributeStatisticVisitor statisticVisitor) {
        this.m_statisticVisitor = statisticVisitor;
    }

    public String getConsolidationFunction() {
        return this.m_consolidationFunction;
    }

    public void setConsolidationFunction(String consolidationFunction) {
        this.m_consolidationFunction = consolidationFunction;
    }

    public Long getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Long endTime) {
        this.m_endTime = endTime;
    }

    public Long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Long startTime) {
        this.m_startTime = startTime;
    }
}

