/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.opennms.netmgt.rrd.RrdUtils;

public class RrdFileConstants {
    public static final int MAX_RRD_FILENAME_LENGTH = 1024;
    public static final FilenameFilter RRD_FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File file, String name) {
            return name.endsWith(RrdFileConstants.getRrdSuffix());
        }
    };
    public static final FileFilter INTERFACE_DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return RrdFileConstants.isValidRRDInterfaceDir(file);
        }
    };
    public static final FileFilter NODE_DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return RrdFileConstants.isValidRRDNodeDir(file);
        }
    };
    public static final FileFilter DOMAIN_DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return RrdFileConstants.isValidRRDDomainDir(file);
        }
    };

    public static final boolean isValidRRDNodeDir(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        try {
            Integer.parseInt(file.getName());
        }
        catch (Exception e) {
            return false;
        }
        File[] nodeRRDs = file.listFiles(RRD_FILENAME_FILTER);
        if (nodeRRDs != null && nodeRRDs.length > 0) {
            return true;
        }
        File[] intfDirs = file.listFiles(INTERFACE_DIRECTORY_FILTER);
        return intfDirs != null && intfDirs.length > 0;
    }

    public static final boolean isValidRRDDomainDir(File file) {
        block3: {
            if (!file.isDirectory()) {
                return false;
            }
            try {
                Integer.parseInt(file.getName());
            }
            catch (Exception e) {
                File[] intfDirs = file.listFiles(INTERFACE_DIRECTORY_FILTER);
                if (intfDirs == null || intfDirs.length <= 0) break block3;
                return true;
            }
        }
        return false;
    }

    public static final boolean isValidRRDInterfaceDir(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] intfRRDs = file.listFiles(RRD_FILENAME_FILTER);
        return intfRRDs != null && intfRRDs.length > 0;
    }

    public static final boolean isValidRRDLatencyDir(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] nodeRRDs = file.listFiles(RRD_FILENAME_FILTER);
        return nodeRRDs != null && nodeRRDs.length > 0;
    }

    public static boolean isValidRRDName(String rrd) {
        if (rrd == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int length = rrd.length();
        if (length > 1024) {
            return false;
        }
        if (rrd.indexOf("..") >= 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = rrd.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '-' || c == '/') continue;
            return false;
        }
        return true;
    }

    public static String convertToValidRrdName(String rrd) {
        if (rrd == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer buffer = new StringBuffer(rrd);
        if (rrd.length() > 1024) {
            buffer.setLength(1023);
        }
        int length = buffer.length();
        for (int i = 0; i < length; ++i) {
            char c = buffer.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '-' || c == '/') continue;
            buffer.setCharAt(i, '_');
        }
        return buffer.toString();
    }

    public static String getRrdSuffix() {
        return RrdUtils.getExtension();
    }
}

