/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.PushbackReader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.filter.SQLTranslation;
import org.opennms.netmgt.filter.lexer.Lexer;
import org.opennms.netmgt.filter.node.Start;
import org.opennms.netmgt.filter.parser.Parser;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcFilterDao
implements FilterDao,
InitializingBean {
    private NodeDao m_nodeDao;
    private DataSource m_dataSource;
    private DatabaseSchemaConfigFactory m_databaseSchemaConfigFactory;

    @Override
    public SortedMap<Integer, String> getNodeMap(String rule) throws FilterParseException {
        TreeMap<Integer, String> resultMap = new TreeMap<Integer, String>();
        String sqlString = null;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Filter: rule: " + rule));
        }
        Connection conn = null;
        try {
            Statement stmt;
            ResultSet rset;
            conn = this.getDataSource().getConnection();
            sqlString = this.getNodeMappingStatement(rule);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Filter: SQL statement: " + sqlString));
            }
            if ((rset = (stmt = conn.createStatement()).executeQuery(sqlString)) != null) {
                while (rset.next()) {
                    resultMap.put(new Integer(rset.getInt(1)), rset.getString(2));
                }
            }
            try {
                rset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        catch (SQLException e) {
            this.log().info((Object)("SQL Exception occured getting node map: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (Exception e) {
            this.log().fatal((Object)("Exception getting database connection: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return resultMap;
    }

    private final Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource cannot be null");
        Assert.state((this.m_databaseSchemaConfigFactory != null ? 1 : 0) != 0, (String)"property databaseSchemaConfigFactory cannot be null");
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setDatabaseSchemaConfigFactory(DatabaseSchemaConfigFactory factory) {
        this.m_databaseSchemaConfigFactory = factory;
    }

    public DatabaseSchemaConfigFactory getDatabaseSchemaConfigFactory() {
        return this.m_databaseSchemaConfigFactory;
    }

    @Override
    public Map<String, Set<String>> getIPServiceMap(String rule) {
        TreeMap<String, Set<String>> ipServices = new TreeMap<String, Set<String>>();
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rset = stmt.executeQuery(this.getIPServiceMappingStatement(rule));
            if (rset != null) {
                while (rset.next()) {
                    String ipaddr = rset.getString(1);
                    if (!ipServices.containsKey(ipaddr)) {
                        ipServices.put(ipaddr, new TreeSet());
                    }
                    ((Set)ipServices.get(ipaddr)).add(rset.getString(2));
                }
            }
            try {
                rset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        catch (SQLException e) {
            this.log().info((Object)("SQL Exception occured getting IP List: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (Exception e) {
            this.log().fatal((Object)("Exception getting database connection: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return ipServices;
    }

    @Override
    public List<String> getIPList(String rule) throws FilterParseException {
        ArrayList<String> resultList = new ArrayList<String>();
        String sqlString = null;
        Connection conn = null;
        try {
            Statement stmt;
            ResultSet rset;
            conn = this.getDataSource().getConnection();
            sqlString = this.getSQLStatement(rule);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Filter: SQL statement: \n" + sqlString));
            }
            if ((rset = (stmt = conn.createStatement()).executeQuery(sqlString)) != null) {
                while (rset.next()) {
                    resultList.add(rset.getString(1));
                }
            }
            try {
                rset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        catch (SQLException e) {
            this.log().info((Object)("SQL Exception occured getting IP List: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (Exception e) {
            this.log().fatal((Object)("Exception getting database connection: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return resultList;
    }

    @Override
    public boolean isValid(String addr, String rule) throws FilterParseException {
        if (rule.length() == 0) {
            return true;
        }
        return this.getIPList(rule).contains(addr);
    }

    @Override
    public void validateRule(String rule) throws FilterParseException {
        this.getSQLStatement(rule);
    }

    private Start parseRule(String rule) throws FilterParseException {
        if (rule != null && rule.length() > 0) {
            try {
                Parser p = new Parser(new Lexer(new PushbackReader(new StringReader(rule))));
                return p.parse();
            }
            catch (Exception e) {
                this.log().error((Object)("Failed to parse the filter rule '" + rule + "': " + e), (Throwable)e);
                throw new FilterParseException("Parse error in rule '" + rule + "': " + e, e);
            }
        }
        throw new FilterParseException("Parse error: rule is null or empty");
    }

    protected String getSQLStatement(String rule) {
        Start parseTree = this.parseRule(rule);
        SQLTranslation translation = new SQLTranslation(parseTree, this.getDatabaseSchemaConfigFactory());
        return translation.getStatement();
    }

    protected String getSQLStatement(String rule, long nodeId, String ipaddr, String service) {
        Start parseTree = this.parseRule(rule);
        SQLTranslation translation = new SQLTranslation(parseTree, this.getDatabaseSchemaConfigFactory());
        translation.setConstraintTranslation(nodeId, ipaddr, service);
        return translation.getStatement();
    }

    protected String getIPServiceMappingStatement(String rule) {
        Start parseTree = this.parseRule(rule);
        SQLTranslation translation = new SQLTranslation(parseTree, this.getDatabaseSchemaConfigFactory());
        translation.setIPServiceMappingTranslation();
        return translation.getStatement();
    }

    protected String getNodeMappingStatement(String rule) {
        Start parseTree = this.parseRule(rule);
        SQLTranslation translation = new SQLTranslation(parseTree, this.getDatabaseSchemaConfigFactory());
        translation.setNodeMappingTranslation();
        return translation.getStatement();
    }

    protected String getInterfaceWithServiceStatement(String rule) {
        Start parseTree = this.parseRule(rule);
        SQLTranslation translation = new SQLTranslation(parseTree, this.getDatabaseSchemaConfigFactory());
        translation.setInterfaceWithServiceTranslation();
        return translation.getStatement();
    }

    @Override
    public boolean isRuleMatching(String rule) {
        Start parseTree = this.parseRule(rule);
        SQLTranslation translation = new SQLTranslation(parseTree, this.getDatabaseSchemaConfigFactory());
        translation.setLimitCount(1);
        String sql = translation.getStatement();
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rows = stmt.executeQuery(sql);
            boolean matches = rows.next();
            try {
                rows.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("isRuleMatching: rule \"" + rule + "\" does " + (matches ? "" : "not ") + "match an entry in the database; converted to SQL: " + sql));
            }
            boolean bl = matches;
            return bl;
        }
        catch (SQLException e) {
            this.log().warn((Object)("SQL Exception occured testing rule \"" + rule + "\" (" + sql + ") for matching results: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (Exception e) {
            this.log().fatal((Object)("Exception getting database connection: " + e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void walkMatchingNodes(String rule, EntityVisitor visitor) {
        SortedMap<Integer, String> map;
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"property nodeDao cannot be null");
        try {
            map = this.getNodeMap(rule);
        }
        catch (FilterParseException e) {
            throw new DataRetrievalFailureException("Could not parse rule '" + rule + "': " + e, (Throwable)e);
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("got " + map.size() + " results"));
        }
        for (Integer nodeId : map.keySet()) {
            OnmsNode node = (OnmsNode)this.getNodeDao().load(nodeId);
            visitor.visitNode(node);
        }
    }
}

