/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigManager;

public final class OpennmsServerConfigFactory
extends OpennmsServerConfigManager {
    private static OpennmsServerConfigFactory m_singleton = null;
    private static boolean m_loaded = false;

    public OpennmsServerConfigFactory(Reader rdr) throws IOException, MarshalException, ValidationException {
        super(rdr);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_SERVER_CONFIG_FILE_NAME);
        FileReader cfgIn = new FileReader(cfgFile);
        m_singleton = new OpennmsServerConfigFactory(cfgIn);
        cfgIn.close();
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        OpennmsServerConfigFactory.init();
    }

    public static synchronized OpennmsServerConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(OpennmsServerConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }
}

