/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.Context;
import org.snmp4j.agent.io.MOInfo;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class MOServerPersistence {
    private static final LogAdapter logger = LogFactory.getLogger((Class)(class$org$snmp4j$agent$io$MOServerPersistence == null ? (class$org$snmp4j$agent$io$MOServerPersistence = MOServerPersistence.class$("org.snmp4j.agent.io.MOServerPersistence")) : class$org$snmp4j$agent$io$MOServerPersistence));
    private MOServer[] servers;
    static /* synthetic */ Class class$org$snmp4j$agent$io$MOServerPersistence;

    public MOServerPersistence(MOServer server) {
        this(new MOServer[]{server});
    }

    public MOServerPersistence(MOServer[] moServers) {
        this.servers = moServers;
    }

    private HashMap buildCache() {
        HashMap<OctetString, LinkedHashMap<OID, ManagedObject>> serializableMO = new HashMap<OctetString, LinkedHashMap<OID, ManagedObject>>();
        serializableMO.clear();
        for (int i = 0; i < this.servers.length; ++i) {
            Iterator it = this.servers[i].iterator();
            while (it.hasNext()) {
                LinkedHashMap<OID, ManagedObject> objects;
                Map.Entry entry = (Map.Entry)it.next();
                MOScope scope = (MOScope)entry.getKey();
                ManagedObject value = (ManagedObject)entry.getValue();
                if (!(value instanceof SerializableManagedObject) || ((SerializableManagedObject)value).isVolatile()) continue;
                OctetString context = null;
                if (scope instanceof MOContextScope) {
                    context = ((MOContextScope)scope).getContext();
                }
                if ((objects = (LinkedHashMap<OID, ManagedObject>)serializableMO.get(context)) == null) {
                    objects = new LinkedHashMap<OID, ManagedObject>();
                    serializableMO.put(context, objects);
                }
                objects.put(((SerializableManagedObject)value).getID(), value);
            }
        }
        return serializableMO;
    }

    public synchronized void loadData(MOInput input) throws IOException {
        int i;
        HashMap serializableMO = this.buildCache();
        LinkedHashMap mos = (LinkedHashMap)serializableMO.get(null);
        if (mos != null) {
            MOServerPersistence.readData(input, mos);
        } else {
            Sequence seq = input.readSequence();
            for (i = 0; i < seq.getSize(); ++i) {
                MOInfo mo = input.readManagedObject();
                input.skipManagedObject(mo);
            }
        }
        Sequence contextSequence = input.readSequence();
        if (contextSequence != null) {
            for (i = 0; i < contextSequence.getSize(); ++i) {
                Context context = input.readContext();
                boolean skip = true;
                for (int s = 0; skip && s < this.servers.length; ++s) {
                    if (!this.servers[s].isContextSupported(context.getContext())) continue;
                    skip = false;
                }
                if (skip) {
                    logger.warn((Object)("Context '" + context.getContext() + "' is no longer supported by agent"));
                    input.skipContext(context);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loading data for context '" + context.getContext() + "'"));
                }
                if ((mos = (LinkedHashMap)serializableMO.get(context.getContext())) == null) {
                    input.skipContext(context);
                    continue;
                }
                MOServerPersistence.readData(input, mos);
                input.skipContext(context);
            }
        }
    }

    private static void readData(MOInput input, LinkedHashMap mos) throws IOException {
        Sequence moGroup = input.readSequence();
        if (moGroup != null) {
            for (int j = 0; j < moGroup.getSize(); ++j) {
                SerializableManagedObject mo;
                MOInfo moid = input.readManagedObject();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Looking up object " + moid.getOID()));
                }
                if ((mo = (SerializableManagedObject)mos.get(moid.getOID())) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Loading data for object " + moid.getOID()));
                    }
                    mo.load(input);
                }
                input.skipManagedObject(moid);
            }
        }
    }

    public synchronized void saveData(MOOutput output) throws IOException {
        HashMap serializableMO = this.buildCache();
        LinkedHashMap mos = (LinkedHashMap)serializableMO.get(null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Trying to write MIB data for all contexts");
        }
        if (mos != null) {
            MOServerPersistence.writeData(output, null, mos);
        } else {
            output.writeSequence(new Sequence(0));
        }
        HashSet<OctetString> contextSet = new HashSet<OctetString>();
        for (int i = 0; i < this.servers.length; ++i) {
            contextSet.addAll(Arrays.asList(this.servers[i].getContexts()));
        }
        OctetString[] contexts = contextSet.toArray(new OctetString[contextSet.size()]);
        output.writeSequence(new Sequence(contexts.length));
        for (int i = 0; i < contexts.length; ++i) {
            Context c = new Context(contexts[i]);
            output.writeContextBegin(c);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to write MIB data for context '" + c.getContext() + "'"));
            }
            if ((mos = (LinkedHashMap)serializableMO.get(c.getContext())) != null) {
                MOServerPersistence.writeData(output, c, mos);
            }
            output.writeContextEnd(c);
        }
    }

    private static void writeData(MOOutput output, Context c, LinkedHashMap mos) throws IOException {
        if (logger.isDebugEnabled()) {
            if (c == null) {
                logger.debug((Object)("Writing " + mos.size() + " context independent managed objects"));
            } else {
                logger.debug((Object)("Writing " + mos.size() + " managed objects for context '" + c.getContext() + "'"));
            }
        }
        output.writeSequence(new Sequence(mos.size()));
        Iterator it = ((HashMap)mos).values().iterator();
        while (it.hasNext()) {
            SerializableManagedObject mo = (SerializableManagedObject)it.next();
            MOInfo moInfo = new MOInfo(mo.getID());
            output.writeManagedObjectBegin(moInfo);
            mo.save(output);
            output.writeManagedObjectEnd(moInfo);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

