/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap.controls;

import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import java.io.IOException;
import org.ietf.ldap.LDAPControl;

public class LDAPEntryChangeControl
extends LDAPControl {
    private int m_changeType;
    private String m_previousDN;
    private boolean m_hasChangeNumber;
    private int m_changeNumber;

    public LDAPEntryChangeControl(String string, boolean bl, byte[] byArray) throws IOException {
        super(string, bl, byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        if (lBERDecoder == null) {
            throw new IOException("Decoding error.");
        }
        ASN1Object aSN1Object = lBERDecoder.decode(byArray);
        if (aSN1Object == null || !(aSN1Object instanceof ASN1Sequence)) {
            throw new IOException("Decoding error.");
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
        ASN1Object aSN1Object2 = aSN1Sequence.get(0);
        if (aSN1Object2 == null || !(aSN1Object2 instanceof ASN1Enumerated)) {
            throw new IOException("Decoding error.");
        }
        this.m_changeType = ((ASN1Enumerated)aSN1Object2).intValue();
        if (aSN1Sequence.size() > 1 && this.m_changeType == 8) {
            aSN1Object2 = aSN1Sequence.get(1);
            if (aSN1Object2 == null || !(aSN1Object2 instanceof ASN1OctetString)) {
                throw new IOException("Decoding error get previous DN");
            }
            this.m_previousDN = ((ASN1OctetString)aSN1Object2).stringValue();
        } else {
            this.m_previousDN = "";
        }
        if (aSN1Sequence.size() == 3) {
            aSN1Object2 = aSN1Sequence.get(2);
            if (aSN1Object2 == null || !(aSN1Object2 instanceof ASN1Integer)) {
                throw new IOException("Decoding error getting change number");
            }
            this.m_changeNumber = ((ASN1Integer)aSN1Object2).intValue();
            this.m_hasChangeNumber = true;
        } else {
            this.m_hasChangeNumber = false;
        }
    }

    public boolean getHasChangeNumber() {
        return this.m_hasChangeNumber;
    }

    public int getChangeNumber() {
        return this.m_changeNumber;
    }

    public int getChangeType() {
        return this.m_changeType;
    }

    public String getPreviousDN() {
        return this.m_previousDN;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPEntryChangeControl: ");
        stringBuffer.append("((oid=" + this.getID() + "");
        stringBuffer.append(",critical=" + this.isCritical() + ")");
        stringBuffer.append("(value=" + this.getValue() + "))");
        stringBuffer.append("(changeType =" + this.getChangeTypeString(this.getChangeType()) + ")");
        stringBuffer.append("(changeNumber =" + this.getChangeNumber() + ")");
        stringBuffer.append("(PreviousDN=" + this.getPreviousDN() + "))");
        return stringBuffer.toString();
    }

    private String getChangeTypeString(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "ADD";
                break;
            }
            case 4: {
                string = "MODIFY";
                break;
            }
            case 8: {
                string = "MODDN";
                break;
            }
            case 2: {
                string = "DELETE";
                break;
            }
            default: {
                string = "Unknown change type: " + String.valueOf(n);
            }
        }
        return string;
    }
}

