/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class LDAPExtendedOperation
implements Cloneable,
Externalizable {
    private String oid;
    private byte[] vals;

    public LDAPExtendedOperation() {
    }

    public LDAPExtendedOperation(String string, byte[] byArray) {
        this.oid = string;
        this.vals = byArray;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            System.arraycopy(this.vals, 0, ((LDAPExtendedOperation)object).vals, 0, this.vals.length);
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public String getID() {
        return this.oid;
    }

    public byte[] getValue() {
        return this.vals;
    }

    protected void setValue(byte[] byArray) {
        this.vals = byArray;
    }

    protected void setID(String string) {
        this.oid = string;
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        for (int i = 0; i < n; ++i) {
            writer.write(string);
        }
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<LDAPExtendedOperation>");
        this.newLine(1, outputStreamWriter);
        outputStreamWriter.write("<requestName>");
        outputStreamWriter.write(this.getID());
        outputStreamWriter.write("</requestName>");
        byte[] byArray = this.getValue();
        if (byArray != null) {
            this.newLine(1, outputStreamWriter);
            outputStreamWriter.write("<requestValue xsi:type=\"xsd:base64Binary\">");
            outputStreamWriter.write(Base64.encode(byArray));
            outputStreamWriter.write("</requestValue>");
        }
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</LDAPExtendedOperation>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPExtendedOperation.getXMLHandler("LDAPExtendedOperation", null));
        return (LDAPExtendedOperation)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String requestName;
            byte[] requestValue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("requestName", this));
                this.setchildelement(new ValueXMLhandler("requestValue", this));
            }

            protected void endElement() {
                LDAPExtendedOperation lDAPExtendedOperation = new LDAPExtendedOperation(this.requestName, this.requestValue);
                this.setObject(lDAPExtendedOperation);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("requestName")) {
                    this.requestName = new String((byte[])object);
                } else if (string.equals("requestValue")) {
                    this.requestValue = (byte[])object;
                }
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LDAPExtendedOperation:");
        stringBuffer.append("((requestName=" + this.getID());
        stringBuffer.append("),(requestValue=" + this.getValue() + "))");
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string = "";
        string = string + "*************************************************************************\n";
        string = string + "** The encrypted data above and below is the Class definition and  ******\n";
        string = string + "** other data specific to Java Serialization Protocol. The data  ********\n";
        string = string + "** which is of most application specific interest is as follows... ******\n";
        string = string + "*************************************************************************\n";
        string = string + "****************** Start of application data ****************************\n";
        string = string + "*************************************************************************\n";
        stringBuffer.append(string);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("<LDAPExtendedOperation>");
        stringBuffer.append(ValueXMLhandler.newLine(1));
        stringBuffer.append("<requestName>");
        stringBuffer.append(this.getID());
        stringBuffer.append("</requestName>");
        byte[] byArray = this.getValue();
        if (byArray != null) {
            stringBuffer.append(ValueXMLhandler.newLine(1));
            stringBuffer.append("<requestValue xsi:type=\"xsd:base64Binary\">");
            stringBuffer.append(Base64.encode(byArray));
            stringBuffer.append("</requestValue>");
        }
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("</LDAPExtendedOperation>");
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string2 = "";
        string2 = string2 + "*************************************************************************\n";
        string2 = string2 + "****************** End of application data ******************************\n";
        string2 = string2 + "*************************************************************************\n";
        stringBuffer.append(string2);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        objectOutput.writeUTF(stringBuffer.toString());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        String string2 = string.substring(string.indexOf(60), string.lastIndexOf(62) + 1);
        StringBuffer stringBuffer = new StringBuffer();
        ValueXMLhandler.parseInput(string2, stringBuffer);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        LDAPExtendedOperation lDAPExtendedOperation = (LDAPExtendedOperation)LDAPExtendedOperation.readDSML(bufferedInputStream);
        this.oid = lDAPExtendedOperation.getID();
        this.vals = lDAPExtendedOperation.getValue();
        lDAPExtendedOperation = null;
    }
}

