/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.util.LDAPReader;
import java.io.IOException;

public class DSMLSearchResults
extends LDAPSearchResults {
    LDAPControl[] controls;
    int msgRespPtr;
    private LDAPReader reader;
    LDAPMessage lastread;
    boolean empty;
    boolean wasRead;

    public DSMLSearchResults(LDAPReader lDAPReader) {
        this.reader = lDAPReader;
        this.empty = false;
        this.wasRead = true;
    }

    public DSMLSearchResults() {
        this.empty = true;
        this.wasRead = true;
    }

    void abandon() {
    }

    public int getCount() {
        return 0;
    }

    public LDAPControl[] getResponseControls() {
        return this.controls;
    }

    public boolean hasMore() {
        if (this.empty) {
            return true;
        }
        if (!this.wasRead) {
            return this.lastread != null;
        }
        this.wasRead = false;
        try {
            this.lastread = this.reader.readMessage();
            if (this.lastread instanceof LDAPResponse) {
                if (this.lastread.getType() == 5) {
                    this.lastread = this.reader.readMessage();
                    if (this.lastread instanceof LDAPResponse) {
                        this.lastread = null;
                        return false;
                    }
                    return this.lastread != null;
                }
                this.lastread = null;
                return false;
            }
            return this.lastread != null;
        }
        catch (LDAPException lDAPException) {
            lDAPException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public LDAPEntry next() throws LDAPException {
        if (this.empty) {
            return null;
        }
        this.wasRead = true;
        if (this.lastread != null) {
            if (this.lastread instanceof LDAPSearchResultReference) {
                LDAPReferralException lDAPReferralException = new LDAPReferralException("Referral", 10, "Referral encountered ");
                lDAPReferralException.setReferrals(((LDAPSearchResultReference)this.lastread).getReferrals());
                throw lDAPReferralException;
            }
            return ((LDAPSearchResult)this.lastread).getEntry();
        }
        return null;
    }
}

