/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.log4j.Category;
import org.opennms.core.concurrent.BarrierSignaler;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public abstract class SnmpWalker {
    private String m_name;
    private CollectionTracker m_tracker;
    private boolean m_error;
    private BarrierSignaler m_signal;
    private InetAddress m_address;
    private WalkerPduBuilder m_pduBuilder;
    private ResponseProcessor m_responseProcessor;
    private int m_maxVarsPerPdu;

    protected SnmpWalker(InetAddress address, String name, int maxVarsPerPdu, int maxRepititions, CollectionTracker tracker) {
        this.m_address = address;
        this.m_signal = new BarrierSignaler(1);
        this.m_name = name;
        this.m_error = false;
        this.m_tracker = tracker;
        this.m_tracker.setMaxRepititions(maxRepititions);
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    protected abstract WalkerPduBuilder createPduBuilder(int var1);

    public void start() {
        this.m_pduBuilder = this.createPduBuilder(this.m_maxVarsPerPdu);
        try {
            this.buildAndSendNextPdu();
        }
        catch (Throwable e) {
            this.handleFatalError(e);
        }
    }

    public int getMaxVarsPerPdu() {
        return this.m_pduBuilder == null ? this.m_maxVarsPerPdu : this.m_pduBuilder.getMaxVarsPerPdu();
    }

    protected void buildAndSendNextPdu() throws IOException {
        if (this.m_tracker.isFinished()) {
            this.handleDone();
        } else {
            this.m_pduBuilder.reset();
            this.m_responseProcessor = this.m_tracker.buildNextPdu(this.m_pduBuilder);
            this.sendNextPdu(this.m_pduBuilder);
        }
    }

    protected abstract void sendNextPdu(WalkerPduBuilder var1) throws IOException;

    public boolean failed() {
        return this.m_error;
    }

    protected void handleAuthError(String msg) {
        this.m_error = true;
        this.m_tracker.setFailed(true);
        this.log().info((Object)(this.getName() + ": Authentication error processing " + this.getName() + " for " + this.m_address));
        this.finish();
    }

    protected void handleDone() {
        this.finish();
    }

    protected void handleError(String msg) {
        this.m_error = true;
        this.m_tracker.setTimedOut(false);
        this.log().info((Object)(this.getName() + ": Error retrieving " + this.getName() + " for " + this.m_address + ": " + msg));
        this.finish();
    }

    protected void handleFatalError(Throwable e) {
        this.m_error = true;
        this.m_tracker.setFailed(true);
        this.log().error((Object)(this.getName() + ": Unexpected Error occurred processing " + this.getName() + " for " + this.m_address), e);
        this.finish();
    }

    protected void handleTimeout(String msg) {
        this.m_error = true;
        this.m_tracker.setTimedOut(true);
        this.log().info((Object)(this.getName() + ": Timeout retrieving " + this.getName() + " for " + this.m_address + ": " + msg));
        this.finish();
    }

    private void finish() {
        this.signal();
        try {
            this.close();
        }
        catch (IOException e) {
            this.log().error((Object)(this.getName() + ": Unexpected Error occured closing snmp session for: " + this.m_address), (Throwable)e);
        }
    }

    protected abstract void close() throws IOException;

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal() {
        SnmpWalker snmpWalker = this;
        synchronized (snmpWalker) {
            this.notifyAll();
        }
        if (this.m_signal != null) {
            this.m_signal.signalAll();
        }
    }

    private final Category log() {
        return ThreadCategory.getInstance(SnmpWalker.class);
    }

    public void waitFor() throws InterruptedException {
        this.m_signal.waitFor();
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.m_signal.waitFor(timeout);
    }

    protected boolean processErrors(int errorStatus, int errorIndex) {
        return this.m_responseProcessor.processErrors(errorStatus, errorIndex);
    }

    protected void processResponse(SnmpObjId receivedOid, SnmpValue val) {
        this.m_responseProcessor.processResponse(receivedOid, val);
    }

    protected void setAddress(InetAddress address) {
        this.m_address = address;
    }

    protected InetAddress getAddress() {
        return this.m_address;
    }

    protected static abstract class WalkerPduBuilder
    extends PduBuilder {
        protected WalkerPduBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
        }

        public abstract void reset();
    }
}

