/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;

public class SnmpAgentConfig {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 161;
    public static final int VERSION1 = 1;
    public static final int VERSION2C = 2;
    public static final int VERSION3 = 3;
    public static final int DEFAULT_VERSION = 1;
    public static final int DEFAULT_RETRIES = 1;
    public static final int DEFAULT_MAX_REQUEST_SIZE = 65535;
    public static final int NOAUTH_NOPRIV = 1;
    public static final int AUTH_NOPRIV = 2;
    public static final int AUTH_PRIV = 3;
    public static final String DEFAULT_READ_COMMUNITY = "public";
    public static final int DEFAULT_MAX_VARS_PER_PDU = 10;
    public static final int DEFAULT_MAX_REPETITIONS = 2;
    public static final String DEFAULT_WRITE_COMMUNITY = "private";
    public static final int DEFAULT_SECURITY_LEVEL = 1;
    public static final String DEFAULT_SECURITY_NAME = "opennmsUser";
    public static final String DEFAULT_AUTH_PASS_PHRASE = "0p3nNMSv3";
    public static final String DEFAULT_AUTH_PROTOCOL = "MD5";
    public static final String DEFAULT_PRIV_PROTOCOL = "DES";
    public static final String DEFAULT_PRIV_PASS_PHRASE = "0p3nNMSv3";
    private InetAddress m_address;
    private int m_timeout;
    private int m_retries;
    private int m_port;
    private int m_version;
    private int m_maxRequestSize;
    private int m_securityLevel;
    private String m_securityName;
    private String m_readCommunity;
    private int m_maxVarsPerPdu;
    private int m_maxRepetitions;
    private String m_writeCommunity;
    private String m_authPassPhrase;
    private String m_authProtocol;
    private String m_PrivProtocol;
    private String m_privPassPhrase;
    private InetAddress m_proxyFor;

    public SnmpAgentConfig() {
        this.setDefaults();
    }

    public SnmpAgentConfig(InetAddress agentAddress) {
        this.m_address = agentAddress;
        this.setDefaults();
    }

    private void setDefaults() {
        this.m_timeout = 3000;
        this.m_retries = 1;
        this.m_port = 161;
        this.m_version = 1;
        this.m_maxRequestSize = 65535;
        this.m_securityLevel = 1;
        this.m_securityName = DEFAULT_SECURITY_NAME;
        this.m_authPassPhrase = "0p3nNMSv3";
        this.m_authProtocol = DEFAULT_AUTH_PROTOCOL;
        this.m_PrivProtocol = DEFAULT_PRIV_PROTOCOL;
        this.m_privPassPhrase = "0p3nNMSv3";
        this.m_readCommunity = DEFAULT_READ_COMMUNITY;
        this.m_maxVarsPerPdu = 10;
        this.m_maxRepetitions = 2;
        this.m_writeCommunity = DEFAULT_WRITE_COMMUNITY;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("AgentConfig[");
        buff.append("Address: " + this.m_address);
        buff.append(", Port: " + this.m_port);
        buff.append(", Community: " + this.m_readCommunity);
        buff.append(", Timeout: " + this.m_timeout);
        buff.append(", Retries: " + this.m_retries);
        buff.append(", MaxVarsPerPdu: " + this.m_maxVarsPerPdu);
        buff.append(", MaxRepititions: " + this.m_maxRepetitions);
        buff.append(", Max request size: " + this.m_maxRequestSize);
        buff.append(", Version: " + this.m_version);
        buff.append(", ProxyForAddress: " + this.m_proxyFor);
        if (this.m_version == 3) {
            buff.append(", Security level: " + this.m_securityLevel);
            buff.append(", Security name: " + this.m_securityName);
            buff.append(", auth-passphrase: " + this.m_authPassPhrase);
            buff.append(", auth-protocol: " + this.m_authProtocol);
            buff.append(", priv-passprhase: " + this.m_privPassPhrase);
            buff.append(", priv-protocol: " + this.m_PrivProtocol);
        }
        buff.append("]");
        return buff.toString();
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getSecurityLevel() {
        return this.m_securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.m_securityLevel = securityLevel;
    }

    public String getSecurityName() {
        return this.m_securityName;
    }

    public void setSecurityName(String securityName) {
        this.m_securityName = securityName;
    }

    public void setReadCommunity(String community) {
        this.m_readCommunity = community;
    }

    public int getMaxRequestSize() {
        return this.m_maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.m_maxRequestSize = maxRequestSize;
    }

    public String getReadCommunity() {
        return this.m_readCommunity;
    }

    public int getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public int getMaxRepetitions() {
        return this.m_maxRepetitions;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.m_maxRepetitions = maxRepetitions;
    }

    public String getWriteCommunity() {
        return this.m_writeCommunity;
    }

    public void setWriteCommunity(String community) {
        this.m_writeCommunity = community;
    }

    public static String versionToString(int version) {
        switch (version) {
            case 1: {
                return "v1";
            }
            case 2: {
                return "v2c";
            }
            case 3: {
                return "v3";
            }
        }
        return "unknown";
    }

    public String getAuthPassPhrase() {
        return this.m_authPassPhrase;
    }

    public void setAuthPassPhrase(String authPassPhrase) {
        this.m_authPassPhrase = authPassPhrase;
    }

    public String getPrivProtocol() {
        return this.m_PrivProtocol;
    }

    public void setPrivProtocol(String authPrivProtocol) {
        this.m_PrivProtocol = authPrivProtocol;
    }

    public String getAuthProtocol() {
        return this.m_authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.m_authProtocol = authProtocol;
    }

    public String getPrivPassPhrase() {
        return this.m_privPassPhrase;
    }

    public void setPrivPassPhrase(String privPassPhrase) {
        this.m_privPassPhrase = privPassPhrase;
    }

    public InetAddress getProxyFor() {
        return this.m_proxyFor;
    }

    public void setProxyFor(InetAddress address) {
        this.m_proxyFor = address;
    }
}

