/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public class ColumnTracker
extends CollectionTracker {
    private SnmpObjId m_base;
    private SnmpObjId m_last;
    private boolean m_finished = false;
    private int m_maxRepetitions;

    public ColumnTracker(SnmpObjId base) {
        this(base, 2);
    }

    public ColumnTracker(SnmpObjId base, int maxRepititions) {
        this.m_base = base;
        this.m_last = base;
        this.m_maxRepetitions = maxRepititions;
    }

    public void setMaxRepititions(int maxRepititions) {
        this.m_maxRepetitions = maxRepititions;
    }

    public boolean isFinished() {
        return this.m_finished || !this.m_base.isPrefixOf(this.m_last);
    }

    public ResponseProcessor buildNextPdu(PduBuilder pduBuilder) {
        if (pduBuilder.getMaxVarsPerPdu() < 1) {
            throw new IllegalArgumentException("maxVarsPerPdu < 1");
        }
        pduBuilder.addOid(this.m_last);
        pduBuilder.setNonRepeaters(0);
        pduBuilder.setMaxRepetitions(this.getMaxRepetitions());
        ResponseProcessor rp = new ResponseProcessor(){

            public void processResponse(SnmpObjId responseObjId, SnmpValue val) {
                SnmpInstId inst;
                if (val.isEndOfMib()) {
                    ColumnTracker.this.receivedEndOfMib();
                }
                ColumnTracker.this.m_last = responseObjId;
                if (ColumnTracker.this.m_base.isPrefixOf(responseObjId) && !ColumnTracker.this.m_base.equals(responseObjId) && (inst = responseObjId.getInstance(ColumnTracker.this.m_base)) != null) {
                    ColumnTracker.this.storeResult(ColumnTracker.this.m_base, inst, val);
                }
            }

            public boolean processErrors(int errorStatus, int errorIndex) {
                if (errorStatus == 0) {
                    return false;
                }
                if (errorStatus == 1) {
                    throw new IllegalArgumentException("Unable to handle tooBigError for next oid request after " + ColumnTracker.this.m_last);
                }
                if (errorStatus == 5) {
                    ColumnTracker.this.reportGenErr("Received genErr reqeusting next oid after " + ColumnTracker.this.m_last + ". Marking column is finished.");
                    ColumnTracker.this.errorOccurred();
                    return true;
                }
                if (errorStatus == 2) {
                    ColumnTracker.this.reportNoSuchNameErr("Received noSuchName reqeusting next oid after " + ColumnTracker.this.m_last + ". Marking column is finished.");
                    ColumnTracker.this.errorOccurred();
                    return true;
                }
                throw new IllegalArgumentException("Unexpected error processing next oid after " + ColumnTracker.this.m_last + ". Aborting!");
            }
        };
        return rp;
    }

    public int getMaxRepetitions() {
        return this.m_maxRepetitions;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.m_maxRepetitions = maxRepetitions;
    }

    protected void receivedEndOfMib() {
        this.m_finished = true;
    }

    protected void errorOccurred() {
        this.m_finished = true;
    }
}

