/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.MessageLength;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.util.CommonTimer;
import org.snmp4j.util.WorkerTask;

public class DefaultTcpTransportMapping
extends TcpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultTcpTransportMapping.class);
    private Map sockets = new Hashtable();
    private WorkerTask server;
    private ServerThread serverThread;
    private CommonTimer socketCleaner;
    private long connectionTimeout = 60000L;
    private boolean serverEnabled = false;
    private static final int MIN_SNMP_HEADER_LENGTH = 6;
    private MessageLengthDecoder messageLengthDecoder = new SnmpMesssageLengthDecoder();

    public DefaultTcpTransportMapping() throws UnknownHostException, IOException {
        super(new TcpAddress(InetAddress.getLocalHost(), 0));
    }

    public DefaultTcpTransportMapping(TcpAddress tcpAddress) throws UnknownHostException, IOException {
        super(tcpAddress);
        this.serverEnabled = true;
    }

    public synchronized void listen() throws IOException {
        if (this.server != null) {
            throw new SocketException("Port already listening");
        }
        this.serverThread = new ServerThread();
        this.server = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultTCPTransportMapping_" + this.getAddress(), this.serverThread, true);
        if (this.connectionTimeout > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        this.server.run();
    }

    public void setPriority(int n) {
        WorkerTask workerTask = this.server;
        if (workerTask instanceof Thread) {
            ((Thread)((Object)workerTask)).setPriority(n);
        }
    }

    public int getPriority() {
        WorkerTask workerTask = this.server;
        if (workerTask instanceof Thread) {
            return ((Thread)((Object)workerTask)).getPriority();
        }
        return 5;
    }

    public void setThreadName(String string) {
        WorkerTask workerTask = this.server;
        if (workerTask instanceof Thread) {
            ((Thread)((Object)workerTask)).setName(string);
        }
    }

    public String getThreadName() {
        WorkerTask workerTask = this.server;
        if (workerTask != null) {
            return ((Thread)((Object)workerTask)).getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        WorkerTask workerTask = this.server;
        if (workerTask != null) {
            workerTask.terminate();
            workerTask.interrupt();
            try {
                workerTask.join();
            }
            catch (InterruptedException interruptedException) {
                logger.warn(interruptedException);
            }
            this.server = null;
            Iterator iterator = this.sockets.values().iterator();
            while (iterator.hasNext()) {
                SocketEntry socketEntry = (SocketEntry)iterator.next();
                try {
                    SocketEntry socketEntry2 = socketEntry;
                    synchronized (socketEntry2) {
                        socketEntry.getSocket().close();
                    }
                    logger.debug("Socket to " + socketEntry.getPeerAddress() + " closed");
                }
                catch (IOException iOException) {
                    logger.debug(iOException);
                }
            }
            if (this.socketCleaner != null) {
                this.socketCleaner.cancel();
            }
            this.socketCleaner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean close(Address address) throws IOException {
        SocketEntry socketEntry;
        if (logger.isDebugEnabled()) {
            logger.debug("Closing socket for peer address " + address);
        }
        if ((socketEntry = (SocketEntry)this.sockets.remove(address)) != null) {
            SocketEntry socketEntry2 = socketEntry;
            synchronized (socketEntry2) {
                socketEntry.getSocket().close();
            }
            logger.info("Socket to " + socketEntry.getPeerAddress() + " closed");
            return true;
        }
        return false;
    }

    public void sendMessage(Address address, byte[] byArray) throws IOException {
        if (this.server == null) {
            this.listen();
        }
        this.serverThread.sendMessage(address, byArray);
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long l) {
        this.connectionTimeout = l;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public MessageLengthDecoder getMessageLengthDecoder() {
        return this.messageLengthDecoder;
    }

    public void setServerEnabled(boolean bl) {
        this.serverEnabled = bl;
    }

    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
        if (messageLengthDecoder == null) {
            throw new NullPointerException();
        }
        this.messageLengthDecoder = messageLengthDecoder;
    }

    public int getMaxInboundMessageSize() {
        return super.getMaxInboundMessageSize();
    }

    public void setMaxInboundMessageSize(int n) {
        this.maxInboundMessageSize = n;
    }

    private synchronized void timeoutSocket(SocketEntry socketEntry) {
        if (this.connectionTimeout > 0L) {
            this.socketCleaner.schedule(new SocketTimeout(socketEntry), this.connectionTimeout);
        }
    }

    public boolean isListening() {
        return this.server != null;
    }

    protected void setSocketOptions(ServerSocket serverSocket) {
    }

    class ServerThread
    implements WorkerTask {
        private byte[] buf;
        private volatile boolean stop = false;
        private Throwable lastError = null;
        private ServerSocketChannel ssc;
        private Selector selector;
        private LinkedList pending = new LinkedList();

        public ServerThread() throws IOException {
            this.buf = new byte[DefaultTcpTransportMapping.this.getMaxInboundMessageSize()];
            this.selector = Selector.open();
            if (DefaultTcpTransportMapping.this.serverEnabled) {
                this.ssc = ServerSocketChannel.open();
                this.ssc.configureBlocking(false);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(DefaultTcpTransportMapping.this.tcpAddress.getInetAddress(), DefaultTcpTransportMapping.this.tcpAddress.getPort());
                DefaultTcpTransportMapping.this.setSocketOptions(this.ssc.socket());
                this.ssc.socket().bind(inetSocketAddress);
                this.ssc.register(this.selector, 16);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPending() {
            LinkedList linkedList = this.pending;
            synchronized (linkedList) {
                for (int i = 0; i < this.pending.size(); ++i) {
                    SocketEntry socketEntry = (SocketEntry)this.pending.getFirst();
                    try {
                        if (socketEntry.getSocket().isConnected()) {
                            socketEntry.getSocket().getChannel().register(this.selector, 4);
                            continue;
                        }
                        socketEntry.getSocket().getChannel().register(this.selector, 8);
                        continue;
                    }
                    catch (IOException iOException) {
                        logger.error(iOException);
                        try {
                            socketEntry.getSocket().getChannel().close();
                            TransportStateEvent transportStateEvent = new TransportStateEvent(DefaultTcpTransportMapping.this, socketEntry.getPeerAddress(), 4, iOException);
                            DefaultTcpTransportMapping.this.fireConnectionStateChanged(transportStateEvent);
                        }
                        catch (IOException iOException2) {
                            logger.error(iOException2);
                        }
                        this.lastError = iOException;
                        if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                        throw new RuntimeException(iOException);
                    }
                }
            }
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(Address address, byte[] byArray) throws IOException {
            Socket socket = null;
            SocketEntry socketEntry = (SocketEntry)DefaultTcpTransportMapping.this.sockets.get(address);
            if (logger.isDebugEnabled()) {
                logger.debug("Looking up connection for destination '" + address + "' returned: " + socketEntry);
                logger.debug(DefaultTcpTransportMapping.this.sockets.toString());
            }
            if (socketEntry != null) {
                socket = socketEntry.getSocket();
            }
            if (socket == null || socket.isClosed() || !socket.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Socket for address '" + address + "' is closed, opening it...");
                }
                this.pending.remove(socketEntry);
                SocketChannel socketChannel = null;
                try {
                    socketChannel = SocketChannel.open();
                    socketChannel.configureBlocking(false);
                    socketChannel.connect(new InetSocketAddress(((TcpAddress)address).getInetAddress(), ((TcpAddress)address).getPort()));
                    socket = socketChannel.socket();
                    socketEntry = new SocketEntry((TcpAddress)address, socket);
                    socketEntry.addMessage(byArray);
                    DefaultTcpTransportMapping.this.sockets.put(address, socketEntry);
                    LinkedList linkedList = this.pending;
                    synchronized (linkedList) {
                        this.pending.add(socketEntry);
                    }
                    this.selector.wakeup();
                    logger.debug("Trying to connect to " + address);
                }
                catch (IOException iOException) {
                    logger.error(iOException);
                    throw iOException;
                }
            }
            socketEntry.addMessage(byArray);
            LinkedList linkedList = this.pending;
            synchronized (linkedList) {
                this.pending.add(socketEntry);
            }
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                while (!this.stop) {
                    block43: {
                        try {
                            if (this.selector.select() <= 0) break block43;
                            if (this.stop) break;
                            object = this.selector.selectedKeys();
                            Iterator<SelectionKey> iterator = object.iterator();
                            while (iterator.hasNext()) {
                                Object object2;
                                Object object3;
                                Object object4;
                                SelectionKey selectionKey = iterator.next();
                                iterator.remove();
                                SocketChannel socketChannel = null;
                                TcpAddress tcpAddress = null;
                                if (selectionKey.isAcceptable()) {
                                    object4 = (ServerSocketChannel)selectionKey.channel();
                                    object3 = ((ServerSocketChannel)object4).accept().socket();
                                    socketChannel = ((Socket)object3).getChannel();
                                    socketChannel.configureBlocking(false);
                                    socketChannel.register(this.selector, 1);
                                    tcpAddress = new TcpAddress(((Socket)object3).getInetAddress(), ((Socket)object3).getPort());
                                    object2 = new SocketEntry(tcpAddress, (Socket)object3);
                                    DefaultTcpTransportMapping.this.sockets.put(tcpAddress, object2);
                                    DefaultTcpTransportMapping.this.timeoutSocket((SocketEntry)object2);
                                    TransportStateEvent transportStateEvent = new TransportStateEvent(DefaultTcpTransportMapping.this, tcpAddress, 1, null);
                                    DefaultTcpTransportMapping.this.fireConnectionStateChanged(transportStateEvent);
                                    if (transportStateEvent.isCancelled()) {
                                        logger.warn("Incoming connection cancelled");
                                        ((Socket)object3).close();
                                        DefaultTcpTransportMapping.this.sockets.remove(tcpAddress);
                                        socketChannel = null;
                                    }
                                } else if (selectionKey.isReadable()) {
                                    socketChannel = (SocketChannel)selectionKey.channel();
                                    tcpAddress = new TcpAddress(socketChannel.socket().getInetAddress(), socketChannel.socket().getPort());
                                } else if (selectionKey.isWritable()) {
                                    try {
                                        object4 = (SocketChannel)selectionKey.channel();
                                        object2 = this.pending;
                                        synchronized (object2) {
                                            try {
                                                object3 = (SocketEntry)this.pending.removeFirst();
                                            }
                                            catch (NoSuchElementException noSuchElementException) {
                                                object3 = null;
                                            }
                                        }
                                        if (object3 != null) {
                                            this.writeMessage((SocketEntry)object3, (SocketChannel)object4);
                                        }
                                    }
                                    catch (IOException iOException) {
                                        if (logger.isDebugEnabled()) {
                                            iOException.printStackTrace();
                                        }
                                        logger.warn(iOException);
                                        object3 = new TransportStateEvent(DefaultTcpTransportMapping.this, tcpAddress, 2, iOException);
                                        DefaultTcpTransportMapping.this.fireConnectionStateChanged((TransportStateEvent)object3);
                                        selectionKey.cancel();
                                    }
                                } else if (selectionKey.isConnectable()) {
                                    try {
                                        object3 = this.pending;
                                        synchronized (object3) {
                                            try {
                                                object4 = (SocketEntry)this.pending.getFirst();
                                                if (object4 != null && !((SocketChannel)(object2 = (SocketChannel)selectionKey.channel())).isConnected() && ((SocketChannel)object2).finishConnect()) {
                                                    ((AbstractSelectableChannel)object2).configureBlocking(false);
                                                    logger.debug("Connected to " + ((SocketEntry)object4).getPeerAddress());
                                                    DefaultTcpTransportMapping.this.timeoutSocket((SocketEntry)object4);
                                                    ((SelectableChannel)object2).register(this.selector, 4);
                                                }
                                            }
                                            catch (NoSuchElementException noSuchElementException) {
                                                object4 = null;
                                            }
                                        }
                                        if (object4 != null) {
                                            object3 = new TransportStateEvent(DefaultTcpTransportMapping.this, tcpAddress, 1, null);
                                            DefaultTcpTransportMapping.this.fireConnectionStateChanged((TransportStateEvent)object3);
                                        } else {
                                            logger.warn("Message not found on finish connection");
                                        }
                                    }
                                    catch (IOException iOException) {
                                        if (logger.isDebugEnabled()) {
                                            iOException.printStackTrace();
                                        }
                                        logger.warn(iOException);
                                        selectionKey.cancel();
                                    }
                                }
                                if (socketChannel == null) continue;
                                try {
                                    this.readMessage(selectionKey, socketChannel, tcpAddress);
                                }
                                catch (IOException iOException) {
                                    if (logger.isDebugEnabled()) {
                                        iOException.printStackTrace();
                                    }
                                    logger.warn(iOException);
                                    selectionKey.cancel();
                                    socketChannel.close();
                                    object3 = new TransportStateEvent(DefaultTcpTransportMapping.this, tcpAddress, 2, iOException);
                                    DefaultTcpTransportMapping.this.fireConnectionStateChanged((TransportStateEvent)object3);
                                }
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            logger.warn("NullPointerException within select()?");
                        }
                    }
                    this.processPending();
                }
                if (this.ssc != null) {
                    this.ssc.close();
                }
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (IOException iOException) {
                logger.error(iOException);
                this.lastError = iOException;
            }
            if (!this.stop) {
                this.stop = true;
                object = DefaultTcpTransportMapping.this;
                synchronized (object) {
                    DefaultTcpTransportMapping.this.server = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMessage(SelectionKey selectionKey, SocketChannel socketChannel, TcpAddress tcpAddress) throws IOException {
            ByteBuffer byteBuffer;
            SocketEntry socketEntry = (SocketEntry)DefaultTcpTransportMapping.this.sockets.get(tcpAddress);
            if (socketEntry != null) {
                socketEntry.used();
                byteBuffer = socketEntry.getReadBuffer();
                if (byteBuffer != null) {
                    socketChannel.read(byteBuffer);
                    if (byteBuffer.hasRemaining()) {
                        socketChannel.register(this.selector, 1, socketEntry);
                    } else {
                        this.dispatchMessage(tcpAddress, byteBuffer, byteBuffer.capacity());
                    }
                    return;
                }
            }
            byteBuffer = ByteBuffer.wrap(this.buf);
            byteBuffer.limit(DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength());
            long l = socketChannel.read(byteBuffer);
            if (logger.isDebugEnabled()) {
                logger.debug("Reading header " + l + " bytes from " + tcpAddress);
            }
            MessageLength messageLength = new MessageLength(0, Integer.MIN_VALUE);
            if (l == (long)DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength()) {
                messageLength = DefaultTcpTransportMapping.this.messageLengthDecoder.getMessageLength(ByteBuffer.wrap(this.buf));
                if (logger.isDebugEnabled()) {
                    logger.debug("Message length is " + messageLength);
                }
                if (messageLength.getMessageLength() > DefaultTcpTransportMapping.this.getMaxInboundMessageSize() || messageLength.getMessageLength() <= 0) {
                    logger.error("Received message length " + messageLength + " is greater than inboundBufferSize " + DefaultTcpTransportMapping.this.getMaxInboundMessageSize());
                    SocketEntry socketEntry2 = socketEntry;
                    synchronized (socketEntry2) {
                        socketEntry.getSocket().close();
                        logger.info("Socket to " + socketEntry.getPeerAddress() + " closed due to an error");
                    }
                } else {
                    byteBuffer.limit(messageLength.getMessageLength());
                    if ((l += (long)socketChannel.read(byteBuffer)) == (long)messageLength.getMessageLength()) {
                        this.dispatchMessage(tcpAddress, byteBuffer, l);
                    } else {
                        byte[] byArray = new byte[byteBuffer.limit()];
                        byteBuffer.flip();
                        byteBuffer.get(byArray, 0, byteBuffer.limit() - byteBuffer.remaining());
                        socketEntry.setReadBuffer(ByteBuffer.wrap(byArray));
                    }
                    socketChannel.register(this.selector, 1, socketEntry);
                }
            } else if (l < 0L) {
                logger.debug("Socket closed remotely");
                selectionKey.cancel();
                socketChannel.close();
                TransportStateEvent transportStateEvent = new TransportStateEvent(DefaultTcpTransportMapping.this, tcpAddress, 2, null);
                DefaultTcpTransportMapping.this.fireConnectionStateChanged(transportStateEvent);
            }
        }

        private void dispatchMessage(TcpAddress tcpAddress, ByteBuffer byteBuffer, long l) {
            ByteBuffer byteBuffer2;
            byteBuffer.flip();
            if (logger.isDebugEnabled()) {
                logger.debug("Received message from " + tcpAddress + " with length " + l + ": " + new OctetString(byteBuffer.array(), 0, (int)l).toHexString());
            }
            if (DefaultTcpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                byte[] byArray = new byte[(int)l];
                System.arraycopy(byteBuffer.array(), 0, byArray, 0, (int)l);
                byteBuffer2 = ByteBuffer.wrap(byArray);
            } else {
                byteBuffer2 = ByteBuffer.wrap(byteBuffer.array(), 0, (int)l);
            }
            DefaultTcpTransportMapping.this.fireProcessMessage(tcpAddress, byteBuffer2);
        }

        private void writeMessage(SocketEntry socketEntry, SocketChannel socketChannel) throws IOException {
            byte[] byArray = socketEntry.nextMessage();
            if (byArray != null) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                socketChannel.write(byteBuffer);
                if (logger.isDebugEnabled()) {
                    logger.debug("Send message with length " + byArray.length + " to " + socketEntry.getPeerAddress() + ": " + new OctetString(byArray).toHexString());
                }
                socketChannel.register(this.selector, 1);
            }
        }

        public void close() {
            this.stop = true;
            WorkerTask workerTask = DefaultTcpTransportMapping.this.server;
            if (workerTask != null) {
                workerTask.terminate();
            }
        }

        public void terminate() {
            this.stop = true;
        }

        public void join() {
        }

        public void interrupt() {
            this.stop = true;
            this.selector.wakeup();
        }
    }

    class SocketTimeout
    extends TimerTask {
        private SocketEntry entry;

        public SocketTimeout(SocketEntry socketEntry) {
            this.entry = socketEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            if (DefaultTcpTransportMapping.this.socketCleaner == null || l - this.entry.getLastUse() >= DefaultTcpTransportMapping.this.connectionTimeout) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Socket has not been used for " + (l - this.entry.getLastUse()) + " micro seconds, closing it");
                }
                DefaultTcpTransportMapping.this.sockets.remove(this.entry.getPeerAddress());
                try {
                    SocketEntry socketEntry = this.entry;
                    synchronized (socketEntry) {
                        this.entry.getSocket().close();
                    }
                    logger.info("Socket to " + this.entry.getPeerAddress() + " closed due to timeout");
                }
                catch (IOException iOException) {
                    logger.error(iOException);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Scheduling " + (this.entry.getLastUse() + DefaultTcpTransportMapping.this.connectionTimeout - l));
                }
                DefaultTcpTransportMapping.this.socketCleaner.schedule(new SocketTimeout(this.entry), this.entry.getLastUse() + DefaultTcpTransportMapping.this.connectionTimeout - l);
            }
        }
    }

    public static class SnmpMesssageLengthDecoder
    implements MessageLengthDecoder {
        public int getMinHeaderLength() {
            return 6;
        }

        public MessageLength getMessageLength(ByteBuffer byteBuffer) throws IOException {
            BER.MutableByte mutableByte = new BER.MutableByte();
            BERInputStream bERInputStream = new BERInputStream(byteBuffer);
            int n = BER.decodeHeader(bERInputStream, mutableByte);
            int n2 = (int)bERInputStream.getPosition();
            MessageLength messageLength = new MessageLength(n2, n);
            return messageLength;
        }
    }

    class SocketEntry {
        private Socket socket;
        private TcpAddress peerAddress;
        private long lastUse;
        private LinkedList message = new LinkedList();
        private ByteBuffer readBuffer = null;

        public SocketEntry(TcpAddress tcpAddress, Socket socket) {
            this.peerAddress = tcpAddress;
            this.socket = socket;
            this.lastUse = System.currentTimeMillis();
        }

        public long getLastUse() {
            return this.lastUse;
        }

        public void used() {
            this.lastUse = System.currentTimeMillis();
        }

        public Socket getSocket() {
            return this.socket;
        }

        public TcpAddress getPeerAddress() {
            return this.peerAddress;
        }

        public synchronized void addMessage(byte[] byArray) {
            this.message.add(byArray);
        }

        public synchronized byte[] nextMessage() {
            if (this.message.size() > 0) {
                return (byte[])this.message.removeFirst();
            }
            return null;
        }

        public void setReadBuffer(ByteBuffer byteBuffer) {
            this.readBuffer = byteBuffer;
        }

        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        public String toString() {
            return "SocketEntry[peerAddress=" + this.peerAddress + ",socket=" + this.socket + ",lastUse=" + new Date(this.lastUse) + "]";
        }
    }
}

