/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.ArrayList;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class BroadcastEventProcessor
implements EventListener,
InitializingBean,
DisposableBean {
    private EventIpcManager m_eventMgr;
    private TrapdIpMgr m_trapdIpMgr;

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public TrapdIpMgr getTrapdIpMgr() {
        return this.m_trapdIpMgr;
    }

    public void setTrapdIpMgr(TrapdIpMgr trapdIpMgr) {
        this.m_trapdIpMgr = trapdIpMgr;
    }

    public void open() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        this.m_eventMgr.addEventListener((EventListener)this, ueiList);
    }

    public void close() {
        this.m_eventMgr.removeEventListener(this);
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"eventManager not set");
        Assert.state((this.m_trapdIpMgr != null ? 1 : 0) != 0, (String)"trapIpMgr not set");
    }

    public void destroy() throws Exception {
        this.close();
    }

    public void onEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            log.warn((Object)"Received an unexpected event with a null UEI");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + eventUei));
        }
        if (eventUei.equals("uei.opennms.org/nodes/nodeGainedInterface") || eventUei.equals("uei.opennms.org/nodes/interfaceReparented")) {
            String action;
            String string = action = eventUei.equals("uei.opennms.org/nodes/interfaceReparented") ? "reparent" : "add";
            if (Long.toString(event.getNodeid()) == null) {
                log.warn((Object)("Not " + action + "ing interface to known node list: " + "nodeId is null"));
            } else if (event.getInterface() == null) {
                log.warn((Object)("Not " + action + "ing interface to known node list: " + "interface is null"));
            } else {
                this.m_trapdIpMgr.setNodeId(event.getInterface(), event.getNodeid());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully " + action + "ed " + event.getInterface() + " to known node list"));
                }
            }
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getInterface() != null) {
                this.m_trapdIpMgr.removeNodeId(event.getInterface());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + event.getInterface() + " from known node list"));
            }
        } else {
            log.warn((Object)("Received an unexpected event with UEI of \"" + eventUei + "\""));
        }
    }

    public String getName() {
        return "Trapd:BroadcastEventProcessor";
    }
}

