/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.collectd.AbstractCollectionSetVisitor;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigManager;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.JdbcIfInfoGetter;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdingVisitor
extends AbstractCollectionSetVisitor {
    private static ThresholdsDao s_thresholdsDao;
    private static ThreshdConfigManager s_threshdConfig;
    private int m_nodeId;
    private List<String> m_groupNameList;
    private String m_hostAddress;
    private String m_serviceName;
    private String m_snmpIfIndex;
    private boolean m_success = true;
    private Map<String, Double> m_cache = new HashMap<String, Double>();
    private Map<String, CollectionAttribute> m_numericAttributeValues;
    private Map<String, String> m_stringAttributeValues;
    private List<ThresholdGroup> m_thresholdGroupList;
    private RrdRepository m_repository;
    private boolean m_needsRefresh = false;

    protected static void initThresholdsDao() {
        DefaultThresholdsDao defaultThresholdsDao = new DefaultThresholdsDao();
        try {
            ThresholdingConfigFactory.init();
            defaultThresholdsDao.setThresholdingConfigFactory(ThresholdingConfigFactory.getInstance());
            defaultThresholdsDao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ThreadCategory.getInstance(ThresholdingVisitor.class).error((Object)("initialize: Could not initialize DefaultThresholdsDao: " + t), t);
            throw new RuntimeException("Could not initialize DefaultThresholdsDao: " + t, t);
        }
        try {
            ThreshdConfigFactory.init();
        }
        catch (Throwable t) {
            ThreadCategory.getInstance(ThresholdingVisitor.class).error((Object)("initialize: Could not initialize ThreshdConfigFactory: " + t), t);
            throw new RuntimeException("Could not initialize ThreshdConfigFactory: " + t, t);
        }
        s_thresholdsDao = defaultThresholdsDao;
        s_threshdConfig = ThreshdConfigFactory.getInstance();
    }

    public static void handleThresholdConfigChanged() {
        ThresholdingVisitor.initThresholdsDao();
    }

    public static ThresholdingVisitor createThresholdingVisitor(int nodeId, String hostAddress, String serviceName, RrdRepository repo, Map params) {
        Category log = ThreadCategory.getInstance(ThresholdingVisitor.class);
        String enabled = (String)params.get("thresholding-enabled");
        if (enabled == null || !enabled.equals("true")) {
            log.warn((Object)"createThresholdingVisitor: Thresholds processing is not enabled. Check thresholding-enabled param on collectd package");
            return null;
        }
        ArrayList<String> groupNameList = new ArrayList<String>();
        for (Package pkg : s_threshdConfig.getConfiguration().getPackage()) {
            if (!s_threshdConfig.serviceInPackageAndEnabled(serviceName, pkg)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("createThresholdingVisitor: address/service: " + hostAddress + "/" + serviceName + " not scheduled, service is not enabled or does not exist in package: " + pkg.getName()));
                continue;
            }
            log.debug((Object)("createThresholdingVisitor: checking ipaddress " + hostAddress + " for inclusion in pkg " + pkg.getName()));
            boolean foundInPkg = s_threshdConfig.interfaceInPackage(hostAddress, pkg);
            if (!foundInPkg) {
                s_threshdConfig.rebuildPackageIpListMap();
                foundInPkg = s_threshdConfig.interfaceInPackage(hostAddress, pkg);
            }
            if (!foundInPkg) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("createThresholdingVisitor: address/service: " + hostAddress + "/" + serviceName + " not scheduled, interface does not belong to package: " + pkg.getName()));
                continue;
            }
            for (Service svc : pkg.getService()) {
                if (!svc.getName().equals(serviceName)) continue;
                String groupName = null;
                for (Parameter parameter : svc.getParameter()) {
                    if (!parameter.getKey().equals("thresholding-group")) continue;
                    groupName = parameter.getValue();
                }
                if (groupName == null) continue;
                groupNameList.add(groupName);
                log.debug((Object)("createThresholdingVisitor:  address/service: " + hostAddress + "/" + serviceName + ". Adding Group " + groupName));
            }
        }
        if (groupNameList.isEmpty()) {
            log.warn((Object)("createThresholdingVisitor: Can't create ThresholdingVisitor for " + hostAddress + "/" + serviceName));
            return null;
        }
        return new ThresholdingVisitor(nodeId, hostAddress, serviceName, repo, groupNameList);
    }

    protected ThresholdingVisitor(int nodeId, String hostAddress, String serviceName, RrdRepository repo, List<String> groupNameList) {
        this.m_groupNameList = groupNameList;
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress;
        this.m_serviceName = serviceName;
        this.m_repository = repo;
        this.initThresholdState();
        this.log().debug((Object)(this + " just created!"));
    }

    public void initThresholdState() {
        this.log().debug((Object)("initThresholdState on " + this));
        this.m_needsRefresh = true;
    }

    @Override
    public void visitResource(CollectionResource resource) {
        this.log().debug((Object)(this + " visiting resource " + resource));
        if (this.m_needsRefresh) {
            this.log().debug((Object)(this + " needs refresh of state; refreshing now"));
            this.m_thresholdGroupList = new ArrayList<ThresholdGroup>();
            for (String groupName : this.m_groupNameList) {
                ThresholdGroup thresholdGroup = s_thresholdsDao.get(groupName);
                if (thresholdGroup == null) {
                    this.log().error((Object)("Could not get threshold group with name " + groupName));
                }
                this.m_thresholdGroupList.add(thresholdGroup);
                this.m_needsRefresh = false;
                if (!this.log().isDebugEnabled()) continue;
                StringBuffer resDebugMsg = new StringBuffer("Resource types after refresh are [");
                resDebugMsg.append("node: { ");
                if (thresholdGroup.getNodeResourceType() != null) {
                    resDebugMsg.append(thresholdGroup.getNodeResourceType());
                }
                resDebugMsg.append(" }; iface: { ");
                if (thresholdGroup.getIfResourceType() != null) {
                    resDebugMsg.append(thresholdGroup.getIfResourceType());
                }
                resDebugMsg.append(" }; generic: { ");
                if (thresholdGroup.getGenericResourceTypeMap() != null) {
                    for (String rType : thresholdGroup.getGenericResourceTypeMap().keySet()) {
                        resDebugMsg.append(rType + " ");
                    }
                }
                resDebugMsg.append(" } ]");
                this.log().debug((Object)resDebugMsg.toString());
            }
        }
        this.m_numericAttributeValues = new HashMap<String, CollectionAttribute>();
        this.m_stringAttributeValues = new HashMap<String, String>();
    }

    @Override
    public void visitAttribute(CollectionAttribute attribute) {
        String numValue = attribute.getNumericValue();
        String attribName = attribute.getName();
        if (numValue != null) {
            this.m_numericAttributeValues.put(attribName, attribute);
            this.log().debug((Object)("visitAttribute storing value " + numValue + " for attribute named " + attribName));
        } else {
            String stringValue = attribute.getStringValue();
            this.m_stringAttributeValues.put(attribName, stringValue);
            this.log().debug((Object)("visitAttribute storing value " + stringValue + " for attribute named " + attribName));
        }
    }

    private String getIfInfo(int nodeid, String ifLabel, String attributeName) {
        return new JdbcIfInfoGetter().getIfInfoForNodeAndLabel(this.m_nodeId, ifLabel).get(attributeName);
    }

    @Override
    public void completeResource(CollectionResource resource) {
        Date date = new Date();
        ArrayList<Event> eventsList = new ArrayList<Event>();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Completing Resource " + resource.getResourceTypeName() + "/" + resource.getOwnerName() + "/" + (resource.getInstance() == null ? "default" : resource.getInstance()) + ": " + resource.getType() + " (" + resource + ")"));
        }
        File resourceDir = resource.getResourceDir(this.m_repository);
        for (ThresholdGroup thresholdGroup : this.m_thresholdGroupList) {
            Map<String, Set<ThresholdEntity>> entityMap;
            String resourceType = resource.getResourceTypeName();
            String ifLabel = null;
            if ("node".equals(resourceType)) {
                entityMap = thresholdGroup.getNodeResourceType().getThresholdMap();
            } else if ("if".equals(resourceType)) {
                entityMap = thresholdGroup.getIfResourceType().getThresholdMap();
                ifLabel = resource.getResourceDir(this.m_repository).getName();
                if (this.m_snmpIfIndex == null) {
                    this.m_snmpIfIndex = this.getIfInfo(this.m_nodeId, ifLabel, "snmpifindex");
                }
            } else {
                Map<String, ThresholdResourceType> typeMap = thresholdGroup.getGenericResourceTypeMap();
                if (typeMap == null) {
                    this.log().error((Object)"Generic Resource Type map was null (this shouldn't happen)");
                    return;
                }
                ThresholdResourceType thisResourceType = typeMap.get(resourceType);
                if (thisResourceType == null) {
                    this.log().warn((Object)("No thresholds configured for resource type " + resourceType + ".  Not processing this collection "));
                    continue;
                }
                entityMap = thisResourceType.getThresholdMap();
            }
            for (String key : entityMap.keySet()) {
                for (ThresholdEntity threshold : entityMap.get(key)) {
                    if (this.passedThresholdFilters(resourceDir, thresholdGroup.getName(), threshold.getDatasourceType(), threshold)) {
                        this.log().info((Object)("Processing threshold " + key + " : " + threshold));
                        Collection<String> requiredDatasources = threshold.getRequiredDatasources();
                        HashMap<String, Double> values = new HashMap<String, Double>();
                        boolean valueMissing = false;
                        for (String ds : requiredDatasources) {
                            this.log().info((Object)("Looking for datasource " + ds));
                            Double dsValue = this.getValue(resource, ds);
                            if (dsValue == null) {
                                this.log().info((Object)("Could not get data source value for '" + ds + "'.  Not evaluating threshold."));
                                valueMissing = true;
                            }
                            values.put(ds, dsValue);
                        }
                        if (valueMissing) continue;
                        this.log().info((Object)"All values found, evaluating");
                        List<Event> thresholdEvents = threshold.evaluateAndCreateEvents(resource.getInstance(), values, date);
                        String dsLabelValue = this.m_stringAttributeValues.get(threshold.getDatasourceLabel());
                        if (dsLabelValue == null) {
                            this.log().info((Object)"No datasource label found in CollectionSet, fetching from storage");
                            dsLabelValue = this.getDataSourceLabelFromFile(resourceDir, threshold);
                        }
                        this.completeEventList(thresholdEvents, ifLabel, this.m_snmpIfIndex, dsLabelValue);
                        eventsList.addAll(thresholdEvents);
                        continue;
                    }
                    this.log().info((Object)("Not processing threshold " + key + " : " + threshold + " because no filters matched"));
                }
            }
        }
        if (eventsList.size() > 0) {
            Events events = new Events();
            for (Event event : eventsList) {
                events.addEvent(event);
            }
            try {
                Log eventLog = new Log();
                eventLog.setEvents(events);
                EventIpcManagerFactory.getIpcManager().sendNow(eventLog);
            }
            catch (Exception e) {
                this.log().info((Object)("completeResource: Failed sending threshold events: " + e), (Throwable)e);
                this.thresholdingFinished(false);
            }
        }
        this.thresholdingFinished(true);
    }

    private Double getValue(CollectionResource resource, String ds) {
        if (this.m_numericAttributeValues.get(ds) == null) {
            this.log().warn((Object)("getValue: can't find attribute called " + ds + " on " + resource));
            return null;
        }
        String numValue = this.m_numericAttributeValues.get(ds).getNumericValue();
        if (numValue == null) {
            this.log().warn((Object)("getValue: can't find numeric value for " + ds + " on " + resource));
            return null;
        }
        String id = resource.toString() + "." + ds;
        Double current = Double.parseDouble(numValue);
        if (!this.m_numericAttributeValues.get(ds).getType().toLowerCase().startsWith("counter")) {
            this.log().debug((Object)("getValue: " + id + "(gauge) value= " + current));
            return current;
        }
        Double last = this.m_cache.get(id);
        this.log().debug((Object)("getValue: " + id + "(counter) last=" + last + ", current=" + current));
        this.m_cache.put(id, current);
        if (last == null) {
            return Double.NaN;
        }
        return current - last;
    }

    private void thresholdingFinished(boolean success) {
        if (success != this.m_success) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: change in thresholding status, generating event.");
            }
            if (success) {
                this.sendEvent("uei.opennms.org/nodes/thresholdingSucceeded");
            } else {
                this.sendEvent("uei.opennms.org/nodes/thresholdingFailed");
            }
        }
        this.m_success = success;
    }

    private void sendEvent(String uei) {
        Category log = this.log();
        Event event = new Event();
        event.setUei(uei);
        event.setNodeid((long)this.m_nodeId);
        event.setInterface(this.m_hostAddress);
        event.setService(this.m_serviceName);
        event.setSource("OpenNMS.Threshd");
        try {
            event.setHost(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException ex) {
            event.setHost("unresolved.host");
        }
        event.setTime(EventConstants.formatToString(new Date()));
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(event);
        }
        catch (Exception ex) {
            log.error((Object)("Failed to send the event " + uei + " for interface " + this.m_hostAddress), (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendEvent: Sent event " + uei + " for " + this.m_nodeId + "/" + this.m_hostAddress + "/" + this.m_serviceName));
        }
    }

    private void completeEventList(List<Event> eventList, String ifLabel, String snmpifIndex, String dsLabelValue) {
        for (Event event : eventList) {
            Value parmValue;
            Parm eventParm;
            event.setNodeid((long)this.m_nodeId);
            event.setService(this.m_serviceName);
            event.setInterface(this.m_hostAddress);
            Parms eventParms = event.getParms();
            if (dsLabelValue != null) {
                eventParm = new Parm();
                eventParm.setParmName("label");
                parmValue = new Value();
                parmValue.setContent(dsLabelValue);
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
            }
            if (ifLabel != null) {
                eventParm = new Parm();
                eventParm.setParmName("ifLabel");
                parmValue = new Value();
                parmValue.setContent(ifLabel);
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
            }
            if (this.m_snmpIfIndex == null) continue;
            eventParm = new Parm();
            eventParm.setParmName("ifIndex");
            parmValue = new Value();
            parmValue.setContent(this.m_snmpIfIndex);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
    }

    private String getDataSourceLabelFromFile(File directory, ThresholdEntity threshold) {
        String dsLabelValue;
        block2: {
            dsLabelValue = null;
            try {
                String key = threshold.getDatasourceLabel();
                dsLabelValue = key == null ? null : ResourceTypeUtils.getStringProperty((File)directory, (String)key);
            }
            catch (DataAccessException e) {
                if (!this.log().isDebugEnabled()) break block2;
                this.log().debug((Object)("getDataSourceLabel: I/O exception when looking for strings.properties file for node id: " + this.m_nodeId + " looking here: " + directory + ": " + (Object)((Object)e)), (Throwable)e);
            }
        }
        return dsLabelValue == null ? "Unknown" : dsLabelValue;
    }

    private boolean passedThresholdFilters(File resourceDir, String thresholdGroup, String resourceType, ThresholdEntity thresholdEntity) {
        ResourceFilter[] filters = thresholdEntity.getThresholdConfig().getBasethresholddef().getResourceFilter();
        if (filters.length == 0) {
            return true;
        }
        this.log().debug((Object)("passedThresholdFilters: resource=" + resourceDir.getName() + ", group=" + thresholdGroup + ", type=" + resourceType + ", filters=" + filters.length));
        int count = 1;
        for (ResourceFilter f : filters) {
            this.log().debug((Object)("passedThresholdFilters: filter #" + count + ": field=" + f.getField() + ", regex='" + f.getContent() + "'"));
            ++count;
            String attr = this.getAttributeValue(resourceDir, resourceType, f.getField());
            if (attr == null) continue;
            Pattern p = Pattern.compile(f.getContent());
            Matcher m = p.matcher(attr);
            boolean pass = m.find();
            this.log().debug((Object)("passedThresholdFilters: the value of " + f.getField() + " is " + attr + ". Pass filter? " + pass));
            if (!pass) continue;
            return true;
        }
        return false;
    }

    private String getAttributeValue(File resourceDirectory, String resourceType, String attribute) {
        this.log().debug((Object)("Getting Value for " + resourceType + "::" + attribute));
        String value = null;
        if (attribute.equals("ID")) {
            return resourceDirectory.getName();
        }
        try {
            if (resourceType.equals("if")) {
                String ifLabel = resourceDirectory.getName();
                value = this.getIfInfo(this.m_nodeId, ifLabel, attribute);
            } else {
                value = this.m_stringAttributeValues.get(attribute);
                if (value == null && (value = this.m_numericAttributeValues.get(attribute).getNumericValue()) == null) {
                    this.log().debug((Object)("Value not found in collection set, getting from " + resourceDirectory));
                    value = ResourceTypeUtils.getStringProperty((File)resourceDirectory, (String)attribute);
                }
            }
        }
        catch (Exception e) {
            this.log().warn((Object)("Can't get value for attribute " + attribute + ". " + e), (Throwable)e);
        }
        return value;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String toString() {
        return "ThresholdingVisitor for node " + this.m_nodeId + "(" + this.m_hostAddress + "), thresholding groups: " + this.m_groupNameList + ", on service " + this.m_serviceName;
    }

    static {
        ThresholdingVisitor.initThresholdsDao();
    }
}

